/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform;

import java.util.Optional;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.metadata.Metadata;
import me.moros.bending.common.util.DummyDataHolder;
import me.moros.bending.paper.platform.PlatformAdapter;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public record BukkitPersistentDataHolder(PersistentDataHolder handle) implements DataHolder
{
    public static DataHolder create(ItemStack itemStack) {
        ItemMeta handle;
        if (!itemStack.isEmpty() && (handle = itemStack.getItemMeta()) != null) {
            return new BukkitPersistentDataHolder((PersistentDataHolder)handle);
        }
        return DummyDataHolder.INSTANCE;
    }

    @Override
    public <T> Optional<T> get(DataKey<T> key) {
        PersistentDataType<?, T> type;
        if (Metadata.isPersistent(key) && (type = PlatformAdapter.dataType(key)) != null) {
            return Optional.ofNullable(this.handle().getPersistentDataContainer().get(PlatformAdapter.nsk(key), type));
        }
        return Optional.empty();
    }

    @Override
    public <T> void add(DataKey<T> key, T value) {
        PersistentDataType<?, T> type;
        if (Metadata.isPersistent(key) && (type = PlatformAdapter.dataType(key)) != null) {
            this.handle().getPersistentDataContainer().set(PlatformAdapter.nsk(key), type, value);
        }
    }

    @Override
    public <T> void remove(DataKey<T> key) {
        if (Metadata.isPersistent(key)) {
            this.handle().getPersistentDataContainer().remove(PlatformAdapter.nsk(key));
        }
    }
}

