/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage.sql.dialect;

import bending.libraries.storage.StorageDataSource;
import bending.libraries.storage.StorageType;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Locale;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.storage.sql.dialect.SqlDialectImpl;
import me.moros.bending.common.storage.sql.dialect.SqlQueries;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.flywaydb.core.api.MigrationVersion;

public sealed interface SqlDialect
extends SqlQueries
permits SqlDialectImpl {
    public boolean nativeUuid();

    public String extraTableOptions();

    default public String uuidType() {
        return this.nativeUuid() ? "UUID" : "BINARY(16)";
    }

    public String defineElementEnumType();

    public String elementEnumType();

    public String insertAbilities();

    public String insertUser();

    public static SqlDialect createFor(Logger logger, StorageDataSource source) {
        StorageType type = source.type();
        if (type == StorageType.SQLITE) {
            throw new IllegalArgumentException();
        }
        boolean nativeUuidSupport = true;
        if (type == StorageType.MYSQL || type == StorageType.MARIADB) {
            boolean isMariaDB;
            MigrationVersion version = SqlDialect.mariaDBVersion(source.source());
            boolean bl = isMariaDB = version != null;
            if (isMariaDB && type == StorageType.MYSQL) {
                logger.warn("Connected database is MariaDB but you've specified MySql engine in config.");
            }
            if (!isMariaDB || !version.isAtLeast("10.7")) {
                logger.warn("You should consider upgrading your database to MariaDB 10.7+");
                nativeUuidSupport = false;
            }
        }
        return new SqlDialectImpl(type, nativeUuidSupport);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable MigrationVersion mariaDBVersion(HikariDataSource source) {
        try (Connection conn = source.getConnection();){
            DatabaseMetaData meta = conn.getMetaData();
            String version = meta.getDatabaseProductVersion();
            if (!version.toLowerCase(Locale.ROOT).contains("mariadb")) return null;
            String rawSemanticVersion = meta.getDatabaseMajorVersion() + "." + meta.getDatabaseMinorVersion();
            MigrationVersion migrationVersion = MigrationVersion.fromVersion((String)rawSemanticVersion);
            return migrationVersion;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

