/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.loader;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.moros.bending.api.addon.Addon;
import me.moros.bending.api.addon.BendingContext;
import me.moros.bending.api.game.Game;
import me.moros.bending.common.loader.AddonClassLoader;
import me.moros.bending.common.loader.AddonLoader;
import me.moros.bending.common.loader.BendingContextImpl;
import me.moros.bending.common.logging.Logger;

record AddonLoaderImpl(Logger logger, AddonClassLoader loader, BendingContext context, Collection<Addon> addons) implements AddonLoader
{
    AddonLoaderImpl(Logger logger, AddonClassLoader loader) {
        this(logger, loader, new BendingContextImpl(), ConcurrentHashMap.newKeySet());
    }

    @Override
    public void loadAll(Collection<Supplier<Addon>> providers) {
        Stream.concat(ServiceLoader.load(Addon.class, this.loader).stream(), providers.stream()).forEach(this::tryLoad);
    }

    private void tryLoad(Supplier<Addon> provider) {
        Addon addon = provider.get();
        try {
            addon.load(this.context);
            this.addons.add(addon);
        }
        catch (Throwable t) {
            this.logger().warn("Unable to load addon %s".formatted(addon.getClass().getName()), t);
        }
    }

    @Override
    public void enableAll(Game game) {
        this.forEachSafe(addon -> addon.enable(game));
    }

    @Override
    public void unloadAll() {
        this.forEachSafe(Addon::unload);
        this.addons.clear();
        try {
            this.loader.close();
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), e);
        }
    }

    private void forEachSafe(Consumer<Addon> addonConsumer) {
        for (Addon addon : this) {
            try {
                addonConsumer.accept(addon);
            }
            catch (Throwable t) {
                this.logger().warn(t.getMessage(), t);
            }
        }
    }

    @Override
    public Iterator<Addon> iterator() {
        return Collections.unmodifiableCollection(this.addons).iterator();
    }
}

