/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.moros.bending.api.config.ConfigProcessor;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.common.config.ConfigProcessorImpl;
import me.moros.bending.common.config.Subscriber;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.util.Debounced;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.reactive.Disposable;
import org.spongepowered.configurate.reference.ConfigurationReference;
import org.spongepowered.configurate.reference.WatchServiceListener;
import org.spongepowered.configurate.util.MapFactories;

public final class ConfigManager {
    private static ConfigManager INSTANCE;
    private final Logger logger;
    private final Collection<Subscriber<? extends Configurable>> subscribers;
    private final ConfigurationReference<CommentedConfigurationNode> reference;
    private final ConfigProcessorImpl processor;
    private final Debounced<?> buffer;
    private final Disposable rootSubscriber;

    public ConfigManager(Logger logger, Path directory, WatchServiceListener listener) throws IOException {
        this.logger = logger;
        this.subscribers = new CopyOnWriteArrayList<Subscriber<? extends Configurable>>();
        Path path = directory.resolve("bending.conf");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        this.reference = listener.listenToConfiguration(this::createLoader, path);
        this.reference.errors().subscribe(e -> logger.warn(((Throwable)e.getValue()).getMessage(), (Throwable)e.getValue()));
        this.processor = new ConfigProcessorImpl(logger, this.reference);
        this.buffer = Debounced.create(this::updateSubscribers, 1L, TimeUnit.SECONDS);
        this.rootSubscriber = this.reference.updates().subscribe(e -> this.buffer.request());
        if (INSTANCE == null) {
            INSTANCE = this;
        }
    }

    private HoconConfigurationLoader createLoader(Path path) {
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(this.withFactory())).path(path)).build();
    }

    private UnaryOperator<ConfigurationOptions> withFactory() {
        return options -> options.mapFactory(MapFactories.sortedNatural()).serializers(builder -> builder.register(Configurable.class, ObjectMapper.factory().asTypeSerializer()));
    }

    private void updateSubscribers() {
        if (!this.subscribers.isEmpty()) {
            CommentedConfigurationNode root = this.config();
            this.subscribers.forEach(s -> s.accept(root));
        }
    }

    public void save() {
        try {
            this.reference.save();
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), e);
        }
    }

    public void close() {
        this.rootSubscriber.dispose();
        this.subscribers.clear();
        this.reference.close();
    }

    private CommentedConfigurationNode config() {
        return (CommentedConfigurationNode)this.reference.node();
    }

    public <T extends Configurable> void subscribe(T def, Consumer<? super T> consumer) {
        Objects.requireNonNull(def);
        Objects.requireNonNull(consumer);
        Subscriber<T> subscriber = new Subscriber<T>(def, consumer);
        this.subscribers.add(subscriber);
        subscriber.accept(this.config());
    }

    public ConfigProcessor processor() {
        return this.processor;
    }

    public static <T extends Configurable> T load(Supplier<T> supplier) {
        return (T)ConfigManager.loadConfigFromNode((ConfigurationNode)INSTANCE.config(), (Configurable)supplier.get());
    }

    public static void cache(Class<? extends Configurable> configType) {
        ConfigManager.INSTANCE.processor.cache(configType);
    }

    private static <T extends Configurable> T loadConfigFromNode(ConfigurationNode node, T def) {
        try {
            return (T)((Configurable)node.node(def.path()).get(def.getClass(), def));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

