/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.commands;

import bending.libraries.cloud.Command;
import bending.libraries.cloud.component.DefaultValue;
import bending.libraries.cloud.minecraft.extras.RichDescription;
import bending.libraries.cloud.parser.ArgumentParseResult;
import bending.libraries.cloud.parser.ArgumentParser;
import bending.libraries.cloud.parser.ParserDescriptor;
import bending.libraries.cloud.parser.aggregate.AggregateParser;
import bending.libraries.cloud.parser.standard.DoubleParser;
import bending.libraries.cloud.parser.standard.EnumParser;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifier;
import me.moros.bending.api.config.attribute.ModifierOperation;
import me.moros.bending.api.config.attribute.ModifyPolicy;
import me.moros.bending.api.user.User;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.command.parser.AbilityParser;
import me.moros.bending.common.command.parser.UserParser;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;

public record ModifierCommand<C extends Audience>(Commander<C> commander) implements Initializer
{
    @Override
    public void init() {
        Command.Builder<C> builder = this.commander().rootBuilder().literal("modifier", new String[0]).commandDescription(RichDescription.of((ComponentLike)Message.MODIFIER_DESC.build())).permission(Permissions.MODIFY);
        ParserDescriptor policyParser = ArgumentParser.firstOf(EnumParser.enumParser(Element.class), AbilityParser.parserGlobal()).flatMapSuccess(ModifyPolicy.class, (ctx, r) -> ArgumentParseResult.successFuture(r.mapEither(ModifyPolicy::of, ModifyPolicy::of)));
        this.commander().register(builder.literal("add", new String[0]).required("policy", policyParser).required("attribute", EnumParser.enumParser(Attribute.class)).required("modifier", this.modifierParser()).optional("target", UserParser.parser(), DefaultValue.parsed("me")).commandDescription(RichDescription.of((ComponentLike)Message.MODIFIER_ADD_DESC.build())).handler(c -> this.onModifierAdd((Audience)c.sender(), (ModifyPolicy)c.get("policy"), (Attribute)((Object)((Object)c.get("attribute"))), (Modifier)c.get("modifier"), (User)c.get("target"))));
        this.commander().register(builder.literal("clear", new String[0]).optional("target", UserParser.parser(), DefaultValue.parsed("me")).commandDescription(RichDescription.of((ComponentLike)Message.MODIFIER_CLEAR_DESC.build())).handler(c -> this.onModifierClear((Audience)c.sender(), (User)c.get("target"))));
    }

    private ParserDescriptor<C, Modifier> modifierParser() {
        return AggregateParser.builder().withComponent("operation", EnumParser.enumParser(ModifierOperation.class)).withComponent("amount", DoubleParser.doubleParser()).withMapper(Modifier.class, (cmdCtx, ctx) -> ArgumentParseResult.successFuture(Modifier.of((ModifierOperation)((Object)((Object)ctx.get("operation"))), (Double)ctx.get("amount")))).build();
    }

    private void onModifierAdd(C sender, ModifyPolicy policy, Attribute attribute, Modifier modifier, User user) {
        user.attributeModifiers().add(policy, attribute, modifier);
        this.recalculate(user);
        Message.MODIFIER_ADD.send((Audience)sender, user.name());
    }

    private void onModifierClear(C sender, User user) {
        user.attributeModifiers().clear();
        this.recalculate(user);
        Message.MODIFIER_CLEAR.send((Audience)sender, user.name());
    }

    private void recalculate(User user) {
        user.game().abilityManager(user.worldKey()).userInstances(user).forEach(Ability::loadConfig);
    }
}

