/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.commands;

import bending.libraries.cloud.Command;
import bending.libraries.cloud.component.DefaultValue;
import bending.libraries.cloud.minecraft.extras.RichDescription;
import bending.libraries.cloud.parser.standard.StringParser;
import java.util.concurrent.atomic.AtomicBoolean;
import me.moros.bending.api.GameProvider;
import me.moros.bending.api.storage.BendingStorage;
import me.moros.bending.common.backup.Operation;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;

public record BackupCommand<C extends Audience>(Commander<C> commander, AtomicBoolean running) implements Initializer
{
    public BackupCommand(Commander<C> commander) {
        this(commander, new AtomicBoolean());
    }

    @Override
    public void init() {
        Command.Builder<C> builder = this.commander().rootBuilder();
        this.commander().register(builder.literal("export", new String[0]).optional("file", StringParser.quotedStringParser(), DefaultValue.constant("")).commandDescription(RichDescription.of((ComponentLike)Message.EXPORT_DESC.build())).permission(Permissions.EXPORT).handler(c -> this.onExport((Audience)c.sender(), (String)c.get("file"))));
        this.commander().register(builder.literal("import", new String[0]).required("file", StringParser.quotedStringParser()).commandDescription(RichDescription.of((ComponentLike)Message.IMPORT_DESC.build())).permission(Permissions.IMPORT).handler(c -> this.onImport((Audience)c.sender(), (String)c.get("file"))));
    }

    private void onExport(C sender, String fileName) {
        BendingStorage storage = GameProvider.get().storage();
        if (this.running.compareAndSet(false, true)) {
            Operation.ofExport(this.commander().plugin(), storage, sender, fileName).execute(this.running);
        } else {
            Message.BACKUP_ALREADY_RUNNING.send((Audience)sender);
        }
    }

    private void onImport(C sender, String fileName) {
        BendingStorage storage = GameProvider.get().storage();
        if (this.running.compareAndSet(false, true)) {
            Operation.ofImport(this.commander().plugin(), storage, sender, fileName).execute(this.running);
        } else {
            Message.BACKUP_ALREADY_RUNNING.send((Audience)sender);
        }
    }
}

