/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.collision;

import java.util.concurrent.atomic.AtomicBoolean;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.common.collision.CollisionView;

public final class CollisionData {
    private final Ability first;
    private final Ability second;
    private final Collider c1;
    private final Collider c2;
    private final AtomicBoolean removeFirst;
    private final AtomicBoolean removeSecond;

    public CollisionData(Ability first, Ability second, Collider c1, Collider c2, boolean removeFirst, boolean removeSecond) {
        this.first = first;
        this.second = second;
        this.c1 = c1;
        this.c2 = c2;
        this.removeFirst = new AtomicBoolean(removeFirst);
        this.removeSecond = new AtomicBoolean(removeSecond);
    }

    public boolean removeFirst() {
        return this.removeFirst.get();
    }

    public boolean removeSecond() {
        return this.removeSecond.get();
    }

    public Collision asCollision() {
        return new CollisionView(this.second, this.c1, this.c2, this.removeFirst, this.removeSecond);
    }

    public Collision asInverseCollision() {
        return new CollisionView(this.first, this.c2, this.c1, this.removeSecond, this.removeFirst);
    }
}

