/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.collision;

import java.util.Collection;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.math.Vector3d;

public final class AABBUtil {
    private static final double MARGIN = 0.01;

    private AABBUtil() {
    }

    public static AABB combine(AABB first, AABB second) {
        return AABB.of((Vector3d)first.min().min(second.min()).subtract(0.01, 0.01, 0.01), first.max().max(second.max()).add(0.01, 0.01, 0.01));
    }

    public static AABB combine(Collection<Collider> colliders) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (Collider collider : colliders) {
            AABB aabb = collider.outer();
            minX = Math.min(minX, aabb.min().x());
            minY = Math.min(minY, aabb.min().y());
            minZ = Math.min(minZ, aabb.min().z());
            maxX = Math.max(maxX, aabb.max().x());
            maxY = Math.max(maxY, aabb.max().y());
            maxZ = Math.max(maxZ, aabb.max().z());
        }
        return AABB.of(Vector3d.of(minX - 0.01, minY - 0.01, minZ - 0.01), Vector3d.of(maxX + 0.01, maxY + 0.01, maxZ + 0.01));
    }
}

