/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.adapter;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import me.moros.bending.common.adapter.EntityMeta;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;

final class EntityDataBuilder {
    private final int id;
    private final Collection<SynchedEntityData.DataValue<?>> dataValues;
    private byte statusFlags;

    EntityDataBuilder(int id) {
        this.id = id;
        this.dataValues = new TreeSet<SynchedEntityData.DataValue>(Comparator.comparingInt(SynchedEntityData.DataValue::id));
        this.statusFlags = 0;
    }

    <T> EntityDataBuilder setRaw(int index, EntityDataSerializer<T> serializer, T data) {
        this.dataValues.add(new SynchedEntityData.DataValue(index, serializer, data));
        return this;
    }

    <T> EntityDataBuilder setRaw(EntityMeta<T> key, T data) {
        return this.setRaw(key.index(), key.serializer(), data);
    }

    EntityDataBuilder noGravity() {
        return this.setRaw(EntityMeta.GRAVITY, true);
    }

    EntityDataBuilder withStatus(EntityMeta.EntityStatus status) {
        this.statusFlags = (byte)(this.statusFlags | 1 << status.index());
        this.setRaw(EntityMeta.ENTITY_STATUS, this.statusFlags);
        return this;
    }

    ClientboundSetEntityDataPacket build() {
        return new ClientboundSetEntityDataPacket(this.id, List.copyOf(this.dataValues));
    }
}

