/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.adapter;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.display.BlockDisplay;
import me.moros.bending.api.platform.entity.display.Display;
import me.moros.bending.api.platform.entity.display.ItemDisplay;
import me.moros.bending.api.platform.entity.display.TextDisplay;
import me.moros.bending.api.platform.entity.display.Transformation;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.common.adapter.AbstractPacketUtil;
import me.moros.bending.common.adapter.EntityDataBuilder;
import me.moros.bending.common.adapter.EntityMeta;
import me.moros.math.Position;
import me.moros.math.Quaternion;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.Component;
import net.minecraft.world.entity.EntityType;
import org.joml.Quaternionf;
import org.joml.Vector3f;

final class DisplayUtil {
    private DisplayUtil() {
    }

    static EntityType<?> mapProperties(AbstractPacketUtil packetUtil, EntityDataBuilder builder, Display<?> properties) {
        DisplayUtil.applyCommon(builder, properties);
        Display<?> display = properties;
        Objects.requireNonNull(display);
        Display<?> display2 = display;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockDisplay.class, ItemDisplay.class, TextDisplay.class}, display2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                BlockDisplay display = (BlockDisplay)display2;
                builder.setRaw(EntityMeta.BLOCK_STATE_ID, packetUtil.adapt((BlockState)display.data()));
                yield EntityType.BLOCK_DISPLAY;
            }
            case 1 -> {
                ItemDisplay display = (ItemDisplay)display2;
                builder.setRaw(EntityMeta.DISPLAYED_ITEM, packetUtil.adapt((Item)display.data()));
                builder.setRaw(EntityMeta.DISPLAY_TYPE, display.displayType().getId());
                yield EntityType.ITEM_DISPLAY;
            }
            case 2 -> {
                TextDisplay display = (TextDisplay)display2;
                builder.setRaw(EntityMeta.TEXT, packetUtil.adapt((Component)display.data()));
                builder.setRaw(EntityMeta.LINE_WIDTH, display.lineWidth());
                builder.setRaw(EntityMeta.BACKGROUND_COLOR, display.backgroundColor());
                builder.setRaw(EntityMeta.OPACITY, display.opacity());
                builder.setRaw(EntityMeta.TEXT_FLAGS, DisplayUtil.packTextDisplayFlagsIntoByte(display.textFlags()));
                yield EntityType.TEXT_DISPLAY;
            }
        };
    }

    static EntityDataBuilder applyTransformation(EntityDataBuilder builder, Transformation transformation) {
        Vector3d offset = (Vector3d)transformation.scale().toVector3d().multiply(-0.5);
        Vector3d translation = ((Vector3d)offset.add(transformation.translation())).add(0.0, 0.5, 0.0);
        return builder.setRaw(EntityMeta.TRANSLATION, DisplayUtil.adapt(translation)).setRaw(EntityMeta.SCALE, DisplayUtil.adapt(transformation.scale())).setRaw(EntityMeta.ROTATION_LEFT, DisplayUtil.adapt(transformation.left())).setRaw(EntityMeta.ROTATION_RIGHT, DisplayUtil.adapt(transformation.right()));
    }

    static EntityDataBuilder applyCommon(EntityDataBuilder builder, Display<?> properties) {
        if (properties.glowColor() != -1) {
            builder.withStatus(EntityMeta.EntityStatus.GLOWING);
        }
        return DisplayUtil.applyTransformation(builder, properties.transformation()).setRaw(EntityMeta.INTERPOLATION_DELAY, properties.interpolationDelay()).setRaw(EntityMeta.TRANSFORMATION_INTERPOLATION_DURATION, properties.transformationInterpolationDuration()).setRaw(EntityMeta.POSITION_INTERPOLATION_DURATION, properties.positionInterpolationDuration()).setRaw(EntityMeta.BILLBOARD, properties.billboard().getId()).setRaw(EntityMeta.BRIGHTNESS, properties.brightness()).setRaw(EntityMeta.VIEW_RANGE, Float.valueOf(properties.viewRange())).setRaw(EntityMeta.SHADOW_RADIUS, Float.valueOf(properties.shadowRadius())).setRaw(EntityMeta.SHADOW_STRENGTH, Float.valueOf(properties.shadowStrength())).setRaw(EntityMeta.WIDTH, Float.valueOf(properties.width())).setRaw(EntityMeta.HEIGHT, Float.valueOf(properties.height())).setRaw(EntityMeta.GLOW_COLOR_OVERRIDE, properties.glowColor());
    }

    static byte packTextDisplayFlagsIntoByte(TextDisplay.TextFlags textFlags) {
        int packedByte = 0;
        if (textFlags.hasShadow()) {
            packedByte = (int)(packedByte | 1);
        }
        if (textFlags.isSeeThrough()) {
            packedByte = (byte)(packedByte | 2);
        }
        if (textFlags.hasDefaultBackground()) {
            packedByte = (byte)(packedByte | 4);
        }
        packedByte = (byte)(packedByte | (switch (textFlags.alignment()) {
            default -> throw new MatchException(null, null);
            case TextDisplay.Alignment.CENTER -> packedByte;
            case TextDisplay.Alignment.LEFT -> 8;
            case TextDisplay.Alignment.RIGHT -> 22;
        }));
        return (byte)packedByte;
    }

    private static Quaternionf adapt(Quaternion rot) {
        return new Quaternionf(rot.q1(), rot.q1(), rot.q2(), rot.q0());
    }

    private static Vector3f adapt(Position vector) {
        return new Vector3f((float)vector.x(), (float)vector.y(), (float)vector.z());
    }
}

