/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.AbstractSpout;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockStateProperties;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.property.Property;
import me.moros.bending.api.platform.property.PropertyHolder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.bending.common.ability.SpoutAbility;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import net.kyori.adventure.util.TriState;

public class WaterSpout
extends AbilityInstance
implements SpoutAbility {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Collection<Block> column = new ArrayList<Block>();
    private final Predicate<Block> predicate = WaterMaterials::isWaterNotPlant;
    private Spout spout;

    public WaterSpout(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).destroyUserInstances(user, WaterSpout.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        double h = this.userConfig.height + 2.0;
        Block block = AbstractSpout.blockCast(user.block(), h);
        if (block == null || !this.predicate.test(block)) {
            return false;
        }
        this.removalPolicy = Policies.defaults();
        this.spout = new Spout();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.spout.update();
    }

    @Override
    public void onDestroy() {
        this.column.forEach(this.spout::clean);
        this.spout.onDestroy();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.spout.collider());
    }

    @Override
    public void handleMovement(Vector3d velocity) {
        if (this.spout != null) {
            this.spout.limitVelocity(velocity, this.userConfig.maxSpeed);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 0L;
        @Modifiable(value=Attribute.HEIGHT)
        private double height = 14.0;
        @Modifiable(value=Attribute.SPEED)
        private double maxSpeed = 0.2;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "waterspout");
        }
    }

    private final class Spout
    extends AbstractSpout {
        private Position lastPosition;
        private final Vector3d g;

        private Spout() {
            super(WaterSpout.this.user, WaterSpout.this.userConfig.height);
            this.g = Vector3d.of(0.0, -0.1, 0.0);
            this.validBlock = WaterSpout.this.predicate;
        }

        @Override
        public void render(Vector3d location) {
            Vector3i newPosition = WaterSpout.this.user.location().toVector3i();
            if (newPosition.equals(this.lastPosition)) {
                return;
            }
            this.lastPosition = newPosition;
            WaterSpout.this.column.forEach(this::clean);
            WaterSpout.this.column.clear();
            this.ignore.clear();
            Block block = WaterSpout.this.user.block();
            TempBlock.water().build(block).ifPresent(tb -> WaterSpout.this.column.add(block));
            PropertyHolder state = BlockType.BUBBLE_COLUMN.defaultState().withProperty((Property)BlockStateProperties.DRAG, Boolean.valueOf(false));
            TempBlock.Builder bubbles = TempBlock.builder((BlockState)state);
            int i = 1;
            while ((double)i < this.distance - 1.0) {
                bubbles.build(block.offset(Direction.DOWN, i)).ifPresent(tb -> WaterSpout.this.column.add(tb.block()));
                ++i;
            }
            this.ignore.addAll(WaterSpout.this.column);
        }

        @Override
        public void postRender(Vector3d location) {
            if (WaterSpout.this.user.checkProperty(EntityProperties.FLYING) != TriState.TRUE) {
                WaterSpout.this.user.applyVelocity(WaterSpout.this, (Vector3d)WaterSpout.this.user.velocity().add(this.g));
            }
            if (ThreadLocalRandom.current().nextInt(8) == 0) {
                SoundEffect.WATER.play(WaterSpout.this.user.world(), location);
            }
        }

        private void clean(Block block) {
            if (MaterialUtil.isWater(block)) {
                TempBlock.air().build(block);
            }
        }
    }
}

