/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.util.BatchQueue;
import me.moros.math.Vector3d;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class PhaseChange
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private PhaseTransformer phaseTransformer;

    public PhaseChange(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        if (method == Activation.ATTACK) {
            this.freeze();
        } else if (method == Activation.SNEAK) {
            this.melt();
        }
        return this.phaseTransformer != null && !this.phaseTransformer.isEmpty();
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.phaseTransformer.processQueue() ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public void onDestroy() {
        if (this.phaseTransformer != null) {
            this.phaseTransformer.clear();
        }
    }

    private void freeze() {
        this.phaseTransformer = new Freeze(this.user, new ArrayDeque<Block>(), this.userConfig.freezeSpeed);
        Vector3d center = this.user.rayTrace(this.userConfig.freezeRange).ignoreLiquids(false).blocks(this.user.world()).position();
        if (this.phaseTransformer.fillQueue(this.getShuffledBlocks(center, this.userConfig.freezeRadius, MaterialUtil::isWater))) {
            this.user.addCooldown(this.description(), this.userConfig.freezeCooldown);
        }
        this.removalPolicy = Policies.builder().build();
    }

    private void melt() {
        this.phaseTransformer = new Melt(this.user, new ArrayDeque<Block>(), this.userConfig.meltSpeed);
        Vector3d center = this.user.rayTrace(this.userConfig.meltRange).blocks(this.user.world()).position();
        if (this.phaseTransformer.fillQueue(this.getShuffledBlocks(center, this.userConfig.meltRadius, MaterialUtil::isMeltable))) {
            this.user.addCooldown(this.description(), 500L);
        }
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
    }

    private Collection<Block> getShuffledBlocks(Vector3d center, double radius, Predicate<Block> predicate) {
        List newBlocks = this.user.world().nearbyBlocks(center, radius, predicate);
        newBlocks.removeIf(b -> !this.user.canBuild((Block)b));
        Collections.shuffle(newBlocks);
        return newBlocks;
    }

    private static interface PhaseTransformer
    extends BatchQueue<Block> {
        public int batchSize();

        default public boolean processQueue() {
            this.processQueue(this.batchSize());
            return this.queue().isEmpty();
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.SELECTION)
        private double freezeRange = 7.0;
        @Modifiable(value=Attribute.RADIUS)
        private double freezeRadius = 3.5;
        @Comment(value="How many blocks can be affected per tick")
        @Modifiable(value=Attribute.SPEED)
        private int freezeSpeed = 8;
        @Modifiable(value=Attribute.COOLDOWN)
        private long freezeCooldown = 2000L;
        @Modifiable(value=Attribute.SELECTION)
        private double meltRange = 7.0;
        @Modifiable(value=Attribute.RADIUS)
        private double meltRadius = 4.5;
        @Comment(value="How many blocks can be affected per tick")
        @Modifiable(value=Attribute.SPEED)
        private int meltSpeed = 8;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "phasechange");
        }
    }

    private record Freeze(User user, Queue<Block> queue, int batchSize) implements PhaseTransformer
    {
        @Override
        public boolean process(Block block) {
            if (!(TempBlock.isBendable(block) && MaterialUtil.isWater(block) && this.user.canBuild(block))) {
                return false;
            }
            TempBlock.ice().build(block);
            if (ThreadLocalRandom.current().nextInt(12) == 0) {
                SoundEffect.ICE.play(block);
            }
            return true;
        }
    }

    private record Melt(User user, Queue<Block> queue, int batchSize) implements PhaseTransformer
    {
        @Override
        public boolean process(Block block) {
            return TempBlock.isBendable(block) && WorldUtil.tryMelt(this.user, block);
        }
    }
}

