/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.ability.water.WaterRing;
import me.moros.math.Vector3d;

public class OctopusForm
extends AbilityInstance {
    private static final double RADIUS = 3.0;
    private static final AABB TENTACLE_BOX = AABB.of(Vector3d.of(-1.0, 0.0, -1.0), Vector3d.of(1.0, 2.5, 1.0));
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Collection<Block> base = new ArrayList<Block>();
    private final List<Tentacle> tentacles = new ArrayList<Tentacle>();
    private final Set<TempBlock> affectedBlocks = new HashSet<TempBlock>();
    private final ExpiringSet<UUID> affectedEntities = new ExpiringSet(500L);
    private WaterRing ring;
    private Block lastBlock;
    private boolean formed = false;
    private long nextTentacleFormTime = 0L;

    public OctopusForm(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        OctopusForm octopusForm = user.game().abilityManager(user.worldKey()).firstInstance(user, OctopusForm.class).orElse(null);
        if (octopusForm != null) {
            octopusForm.punch();
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.defaults();
        this.ring = WaterRing.getOrCreateInstance(user);
        return this.ring != null;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.formed) {
            this.cleanAll();
            if (!this.user.canBuild()) {
                return Updatable.UpdateResult.REMOVE;
            }
            boolean forceUpdate = false;
            Block current = this.user.block();
            if (!current.equals(this.lastBlock)) {
                this.base.clear();
                this.base.addAll(WorldUtil.createBlockRing(current, 3.0));
                this.lastBlock = current;
                forceUpdate = true;
            }
            if (this.base.stream().noneMatch(this.user::canBuild)) {
                return Updatable.UpdateResult.REMOVE;
            }
            this.renderBase();
            int size = this.tentacles.size();
            if (size < 8 && System.currentTimeMillis() >= this.nextTentacleFormTime) {
                this.tentacles.add(new Tentacle(size));
            }
            this.renderTentacles(forceUpdate);
        } else {
            if (this.ring.isDestroyed()) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (this.ring.isReady() && this.user.sneaking()) {
                this.form();
            }
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private void form() {
        if (!this.user.hasAbilitySelected("octopusform")) {
            return;
        }
        this.ring.complete().forEach(this::clean);
        this.formed = true;
        this.nextTentacleFormTime = System.currentTimeMillis() + 150L;
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
    }

    private void renderBase() {
        for (Block block : this.base) {
            Block below = block.offset(Direction.DOWN);
            if (MaterialUtil.isWater(below) && TempBlock.isBendable(below)) {
                TempBlock.ice().duration(BendingProperties.instance().iceRevertTime()).build(below);
            }
            this.renderWaterBlock(block);
        }
    }

    private void renderTentacles(boolean forceUpdate) {
        Vector3d center = this.user.location().center();
        long time = System.currentTimeMillis();
        for (Tentacle tentacle : this.tentacles) {
            if (forceUpdate || time > tentacle.nextUpdateTime) {
                tentacle.updateBlocks(center);
            }
            tentacle.blocks.forEach(this::renderWaterBlock);
        }
    }

    private void renderWaterBlock(Block block) {
        if (!TempBlock.isBendable(block)) {
            return;
        }
        if (MaterialUtil.isWater(block)) {
            ParticleBuilder.bubble(block).spawn(this.user.world());
        } else if (MaterialUtil.isTransparent(block)) {
            TempBlock.water().duration(250L).build(block).ifPresent(this.affectedBlocks::add);
        }
    }

    private void punch() {
        if (!this.formed) {
            return;
        }
        Vector3d center = this.user.location().floor().add(0.5, 0.0, 0.5);
        double r = 3.5;
        for (double phi = 0.0; phi < Math.PI * 2; phi += 0.7853981633974483) {
            Vector3d tentacleBase = center.add(Math.cos(phi) * r, 0.0, Math.sin(phi) * r);
            CollisionUtil.handle(this.user, TENTACLE_BOX.at(tentacleBase), this::onEntityHit, true);
        }
    }

    private boolean onEntityHit(Entity entity) {
        if (this.affectedEntities.add(entity.uuid())) {
            entity.damage(this.userConfig.damage, this.user, this.description());
            Vector3d dir = (Vector3d)((Vector3d)entity.center().subtract(this.user.location())).normalize().multiply(this.userConfig.knockback);
            entity.applyVelocity(this, dir);
        }
        return false;
    }

    private void clean(Block block) {
        if (MaterialUtil.isWater(block)) {
            TempBlock.air().build(block);
        }
    }

    private void cleanAll() {
        for (TempBlock tb : this.affectedBlocks) {
            TempBlock.air().fixWater(false).build(tb.block());
        }
        this.affectedBlocks.clear();
    }

    @Override
    public void onDestroy() {
        if (this.formed) {
            this.user.addCooldown(this.description(), this.userConfig.cooldown);
            this.cleanAll();
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 1000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 1.75;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "octopusform");
        }
    }

    private final class Tentacle {
        private final Collection<Block> blocks = new ArrayList<Block>();
        private final double cos;
        private final double sin;
        private final long topFormTime;
        private long nextUpdateTime;

        private Tentacle(int index) {
            double phi = (double)index * Math.PI / 4.0;
            this.cos = Math.cos(phi);
            this.sin = Math.sin(phi);
            this.topFormTime = System.currentTimeMillis() + 150L;
            this.updateBlocks(OctopusForm.this.user.location().center());
        }

        private void updateBlocks(Vector3d center) {
            this.blocks.clear();
            long time = System.currentTimeMillis();
            this.nextUpdateTime = time + ThreadLocalRandom.current().nextLong(250L, 550L);
            double bottomOffset = ThreadLocalRandom.current().nextDouble(1.0);
            double xBottom = this.cos * (3.0 + bottomOffset);
            double zBottom = this.sin * (3.0 + bottomOffset);
            this.blocks.add(OctopusForm.this.user.world().blockAt(center.add(xBottom, 1.0, zBottom)));
            if (time > this.topFormTime) {
                double topOffset = ThreadLocalRandom.current().nextDouble(1.0);
                double xTop = this.cos * (3.0 + topOffset);
                double zTop = this.sin * (3.0 + topOffset);
                this.blocks.add(OctopusForm.this.user.world().blockAt(center.add(xTop, 2.0, zTop)));
            }
        }
    }
}

