/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public class IceWall
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<IceWallColumn> pillars = MultiUpdatable.empty();
    private final Collection<Block> wallBlocks = new ArrayList<Block>();
    private Block origin;

    public IceWall(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        Block targetBlock = user.rayTrace(this.userConfig.selectRange).blocks(user.world()).block();
        if (targetBlock != null && WaterMaterials.isIceBendable(targetBlock) && FragileStructure.tryDamageStructure(targetBlock, 0, Ray.ZERO)) {
            return false;
        }
        if (user.onCooldown(this.description())) {
            return false;
        }
        this.origin = user.find(this.userConfig.selectRange, WaterMaterials::isWaterOrIceBendable);
        if (this.origin == null) {
            return false;
        }
        this.raiseWall(this.userConfig.maxHeight, this.userConfig.width);
        if (!this.pillars.isEmpty()) {
            user.addCooldown(this.description(), this.userConfig.cooldown);
            this.removalPolicy = Policies.defaults();
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.pillars.update();
    }

    private void createPillar(Block block, int height) {
        int h = this.validate(block, height);
        if (h > 0) {
            this.pillars.add(new IceWallColumn(block, h));
        }
    }

    private int validate(Block block, int height) {
        if (!WaterMaterials.isWaterOrIceBendable(block) || !TempBlock.isBendable(block)) {
            return 0;
        }
        if (!this.user.canBuild(block)) {
            return 0;
        }
        for (int i = 0; i < height; ++i) {
            Block forwardBlock = block.offset(Direction.UP, i + 1);
            if (!this.user.canBuild(forwardBlock)) {
                return i;
            }
            if (MaterialUtil.isTransparent(forwardBlock) || WaterMaterials.isWaterOrIceBendable(forwardBlock)) continue;
            return i;
        }
        return height;
    }

    private void raiseWall(int height, int width) {
        double w = (double)(width - 1) / 2.0;
        Vector3d side = this.user.direction().cross(Vector3d.PLUS_J).normalize();
        Vector3d center = this.origin.center();
        int min = -FastMath.ceil(w);
        int max = FastMath.floor(w);
        for (int i = min; i <= max; ++i) {
            Block check = this.user.world().blockAt((Position)center.add((Position)side.multiply(i)));
            int h = height - Math.min(FastMath.ceil((double)height / 3.0), Math.abs(i));
            if (WaterMaterials.isWaterOrIceBendable(check)) {
                this.createPillar(check, h);
                continue;
            }
            check.world().findTop(check, h, WaterMaterials::isWaterOrIceBendable).ifPresent(b -> this.createPillar((Block)b, h));
        }
    }

    @Override
    public void onDestroy() {
        FragileStructure.builder().health(this.userConfig.wallHealth).predicate(WaterMaterials::isIceBendable).add(this.wallBlocks).build();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 6.0;
        @Modifiable(value=Attribute.HEIGHT)
        private int maxHeight = 6;
        @Modifiable(value=Attribute.RADIUS)
        private int width = 5;
        @Modifiable(value=Attribute.STRENGTH)
        private int wallHealth = 12;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "icewall");
        }
    }

    private final class IceWallColumn
    implements Updatable {
        private final Block origin;
        private final int length;
        private int currentLength = 0;
        private long nextUpdateTime = 0L;

        private IceWallColumn(Block origin, int length) {
            this.origin = origin;
            this.length = length;
        }

        @Override
        public Updatable.UpdateResult update() {
            if (this.currentLength >= this.length) {
                return Updatable.UpdateResult.REMOVE;
            }
            long time = System.currentTimeMillis();
            if (time < this.nextUpdateTime) {
                return Updatable.UpdateResult.CONTINUE;
            }
            this.nextUpdateTime = time + 70L;
            Block currentIndex = this.origin.offset(Direction.UP, this.currentLength);
            ++this.currentLength;
            if (this.isValidBlock(currentIndex)) {
                IceWall.this.wallBlocks.add(currentIndex);
                SoundEffect.ICE.play(currentIndex);
                TempBlock.ice().build(currentIndex);
                return Updatable.UpdateResult.CONTINUE;
            }
            return Updatable.UpdateResult.REMOVE;
        }

        private boolean isValidBlock(Block block) {
            if (MaterialUtil.isLava(block) || !TempBlock.isBendable(block) || !IceWall.this.user.canBuild(block)) {
                return false;
            }
            WorldUtil.tryBreakPlant(block);
            return MaterialUtil.isTransparent(block) || WaterMaterials.isWaterOrIceBendable(block);
        }
    }
}

