/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.math.Vector3d;

public class IceSpike
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<IcePillar> pillars = MultiUpdatable.empty();
    private final Set<UUID> affectedEntities = new HashSet<UUID>();

    public IceSpike(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        boolean field;
        this.user = user;
        this.loadConfig();
        boolean bl = field = method == Activation.SNEAK;
        if (field) {
            Sphere collider = Sphere.of(user.location(), this.userConfig.fieldRadius);
            CollisionUtil.handle(user, collider, this::createPillar, true);
        } else {
            Block base;
            Block source = null;
            Entity entity = user.rayTrace(this.userConfig.selectRange).cast(user.world()).entity();
            if (entity != null && user.canBuild(base = entity.block().offset(Direction.DOWN)) && WaterMaterials.isIceBendable(base) && TempBlock.isBendable(base)) {
                source = base;
            }
            if (source == null && (source = user.find(this.userConfig.selectRange, WaterMaterials::isIceBendable)) == null) {
                return false;
            }
            this.buildPillar(source);
        }
        if (!this.pillars.isEmpty()) {
            user.addCooldown(this.description(), field ? this.userConfig.fieldCooldown : this.userConfig.columnCooldown);
            this.removalPolicy = Policies.defaults();
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.pillars.update();
    }

    private boolean createPillar(Entity entity) {
        Block base = entity.block().offset(Direction.DOWN);
        boolean unique = this.pillars.stream().noneMatch(p -> p.origin.blockX() == base.blockX() && p.origin.blockZ() == base.blockZ());
        if (WaterMaterials.isIceBendable(base)) {
            if (unique) {
                base.state().asParticle(entity.center()).count(8).offset(1.0, 0.1, 1.0).spawn(this.user.world());
                this.buildPillar(base);
            }
            return true;
        }
        return false;
    }

    private void buildPillar(Block block) {
        int h = this.validate(block);
        if (h > 0) {
            this.pillars.add(new IcePillar(block, h));
        }
    }

    private int validate(Block block) {
        int height = this.userConfig.columnMaxHeight;
        if (!WaterMaterials.isIceBendable(block) || !TempBlock.isBendable(block)) {
            return 0;
        }
        if (!this.user.canBuild(block)) {
            return 0;
        }
        for (int i = 0; i < height; ++i) {
            Block forwardBlock = block.offset(Direction.UP, i + 1);
            if (!this.user.canBuild(forwardBlock)) {
                return i;
            }
            if (MaterialUtil.isTransparent(forwardBlock) || forwardBlock.type() == BlockType.WATER) continue;
            return i;
        }
        return height;
    }

    private void clean(Block block) {
        if (WaterMaterials.isIceBendable(block)) {
            TempBlock.air().build(block);
        }
    }

    @Override
    public void onDestroy() {
        for (IcePillar pillar : this.pillars) {
            pillar.pillarBlocks.forEach(this::clean);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 10.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockup = 0.8;
        @Modifiable(value=Attribute.FREEZE_TICKS)
        private int freezeTicks = 80;
        @Modifiable(value=Attribute.COOLDOWN)
        private long columnCooldown = 1500L;
        @Modifiable(value=Attribute.HEIGHT)
        private int columnMaxHeight = 5;
        @Modifiable(value=Attribute.COOLDOWN)
        private long fieldCooldown = 5000L;
        @Modifiable(value=Attribute.RADIUS)
        private double fieldRadius = 10.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "icespike");
        }
    }

    private final class IcePillar
    implements Updatable {
        private final Block origin;
        private final BlockType material;
        private final Deque<Block> pillarBlocks;
        private final int length;
        private boolean reverting = false;
        private int currentLength = 0;
        private long nextUpdateTime = 0L;

        private IcePillar(Block origin, int length) {
            this.origin = origin;
            this.material = origin.type();
            this.length = length;
            this.pillarBlocks = new ArrayDeque<Block>(length);
        }

        @Override
        public Updatable.UpdateResult update() {
            long time;
            if (this.reverting && this.pillarBlocks.isEmpty()) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (!this.reverting && this.currentLength >= this.length) {
                this.reverting = true;
            }
            if ((time = System.currentTimeMillis()) < this.nextUpdateTime) {
                return Updatable.UpdateResult.CONTINUE;
            }
            this.nextUpdateTime = time + 70L;
            if (this.reverting) {
                if (this.pillarBlocks.isEmpty()) {
                    return Updatable.UpdateResult.REMOVE;
                }
                Block block = this.pillarBlocks.pollFirst();
                IceSpike.this.clean(block);
                SoundEffect.ICE.play(block);
                return Updatable.UpdateResult.CONTINUE;
            }
            Block currentIndex = this.origin.offset(Direction.UP, ++this.currentLength);
            AABB collider = AABB.BLOCK_BOUNDS.at(currentIndex);
            CollisionUtil.handle(IceSpike.this.user, collider, this::onEntityHit, true, true);
            if (this.canMove(currentIndex)) {
                this.pillarBlocks.offerFirst(currentIndex);
                TempBlock.builder(this.material).build(currentIndex);
                SoundEffect.ICE.play(currentIndex);
            } else {
                this.reverting = true;
            }
            return Updatable.UpdateResult.CONTINUE;
        }

        private boolean canMove(Block newBlock) {
            if (MaterialUtil.isLava(newBlock)) {
                return false;
            }
            if (!MaterialUtil.isTransparent(newBlock) && newBlock.type() != BlockType.WATER) {
                return false;
            }
            WorldUtil.tryBreakPlant(newBlock);
            return true;
        }

        private boolean onEntityHit(Entity entity) {
            if (!entity.uuid().equals(IceSpike.this.user.uuid()) && IceSpike.this.affectedEntities.add(entity.uuid())) {
                BendingEffect.FROST_TICK.apply(IceSpike.this.user, entity, IceSpike.this.userConfig.freezeTicks);
                entity.damage(IceSpike.this.userConfig.damage, IceSpike.this.user, IceSpike.this.description());
            }
            entity.applyVelocity(IceSpike.this, (Vector3d)Vector3d.PLUS_J.multiply(IceSpike.this.userConfig.knockup));
            return true;
        }
    }
}

