/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.SimpleAbility;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;

public class FrostBreath
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<FrostStream> streams = MultiUpdatable.empty();
    private final Set<UUID> affectedEntities = new HashSet<UUID>();

    public FrostBreath(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, FrostBreath.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).add(Policies.UNDER_WATER).add(ExpireRemovalPolicy.of(this.userConfig.duration)).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.affectedEntities.clear();
        this.user.editProperty(EntityProperties.REMAINING_OXYGEN, air -> air - 5);
        Vector3d offset = Vector3d.of(0.0, -0.1, 0.0);
        Ray ray = Ray.of((Vector3d)this.user.eyeLocation().add(offset), (Vector3d)this.user.direction().multiply(this.userConfig.range));
        this.streams.add(new FrostStream(ray));
        return this.streams.update();
    }

    @Override
    public void onDestroy() {
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(SimpleAbility::collider).toList();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 10000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 7.0;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 1500L;
        @Modifiable(value=Attribute.FREEZE_TICKS)
        private int freezeTicks = 5;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "frostbreath");
        }
    }

    private class FrostStream
    extends ParticleStream {
        private static final SoundEffect SNOW_EFFECT = Sound.BLOCK_POWDER_SNOW_FALL.asEffect(1.0f, 0.7f);
        private static final double ORIGINAL_COLLISION_RADIUS = 0.5;

        public FrostStream(Ray ray) {
            super(FrostBreath.this.user, ray, 0.6, 0.5);
            this.canCollide = BlockProperties::isLiquid;
        }

        @Override
        public void render(Vector3d location) {
            double offset = 0.15 * this.distanceTravelled;
            this.collisionRadius = 0.5 + offset;
            int count = FastMath.ceil(0.35 * this.distanceTravelled);
            int iceCount = FastMath.ceil(0.25 * this.distanceTravelled);
            Particle.SNOWFLAKE.builder(location).count(count).offset(offset).extra(0.02).spawn(FrostBreath.this.user.world());
            BlockType.PACKED_ICE.asParticle(location).count(iceCount).offset(offset).extra(0.02).spawn(FrostBreath.this.user.world());
        }

        @Override
        public void postRender(Vector3d location) {
            for (Block block : FrostBreath.this.user.world().nearbyBlocks(location, this.collisionRadius)) {
                if (!FrostBreath.this.user.canBuild(block)) continue;
                this.onBlockHit(block);
            }
            if (ThreadLocalRandom.current().nextInt(3) == 0) {
                SNOW_EFFECT.play(FrostBreath.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (FrostBreath.this.affectedEntities.add(entity.uuid())) {
                BendingEffect.FROST_TICK.apply(FrostBreath.this.user, entity, FrostBreath.this.userConfig.freezeTicks);
                BlockType.ICE.asParticle(entity.center()).count(5).offset(0.5).spawn(FrostBreath.this.user.world());
            }
            return false;
        }

        @Override
        public boolean onBlockHit(Block block) {
            Block below;
            long duration = BendingProperties.instance().iceRevertTime(2000L);
            if (MaterialUtil.isWater(block)) {
                TempBlock.ice().duration(duration).build(block);
                if (ThreadLocalRandom.current().nextInt(6) == 0) {
                    SoundEffect.ICE.play(block);
                }
            } else if (MaterialUtil.isTransparent(block) && (below = block.offset(Direction.DOWN)).type().isSolid() && !WaterMaterials.isIceBendable(below) && TempBlock.isBendable(below)) {
                TempBlock.builder(BlockType.SNOW).bendable(true).duration(duration).build(block);
            }
            WorldUtil.tryCoolLava(FrostBreath.this.user, block);
            return true;
        }
    }
}

