/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.platform.item.PlayerInventory;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.util.BatchQueue;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HeatControl
extends AbilityInstance {
    private static final DataKey<Mode> KEY = KeyUtil.data("heatcontrol-mode", Mode.class);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private HeatControlState state;
    private boolean sneakActivation;

    public HeatControl(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        boolean bl = this.sneakActivation = method == Activation.SNEAK;
        if (user.game().abilityManager(user.worldKey()).userInstances(user, HeatControl.class).anyMatch(h -> this.sneakActivation == h.sneakActivation)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = this.sneakActivation ? Policies.builder().add(Policies.NOT_SNEAKING).add(SwappedSlotsRemovalPolicy.of(this.description())).build() : Policies.defaults();
        if (user.store().get(KEY).orElse(Mode.COOLING) == Mode.COOLING) {
            this.state = this.sneakActivation ? this.coolLava() : this.extinguish();
        } else {
            HeatControlState heatControlState = this.state = this.sneakActivation ? this.cooking() : this.melt();
        }
        if (this.state != null && this.state.shouldAddCooldown()) {
            user.addCooldown(this.description(), this.userConfig.cooldown);
        }
        return this.state != null;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.state.update();
    }

    @Override
    public void onDestroy() {
        this.state.onDestroy();
    }

    private @Nullable HeatControlState extinguish() {
        Collection<Block> blocks = this.getShuffledBlocks(this.userConfig.range, this.userConfig.radius, HeatControl::isExtinguishable);
        return this.tryCreateBatchProcessor(16, WorldUtil::tryExtinguishFire, blocks);
    }

    private @Nullable HeatControlState coolLava() {
        Collection<Block> blocks = this.getShuffledBlocks(this.userConfig.solidifyRange, this.userConfig.solidifyRadius, MaterialUtil::isLava);
        return this.tryCreateBatchProcessor(1, WorldUtil::tryCoolLava, blocks);
    }

    private @Nullable HeatControlState melt() {
        Collection<Block> blocks = this.getShuffledBlocks(this.userConfig.range, this.userConfig.radius, MaterialUtil::isMeltable);
        return this.tryCreateBatchProcessor(4, WorldUtil::tryMelt, blocks);
    }

    private HeatControlState cooking() {
        Heating result = new Heating(this.user, this.userConfig.cookInterval, this.userConfig.chargeTime);
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return result;
    }

    private Collection<Block> getShuffledBlocks(double range, double radius, Predicate<Block> predicate) {
        Vector3d center = this.user.rayTrace(range).blocks(this.user.world()).position();
        List blocks = this.user.world().nearbyBlocks(center, radius, predicate.and(this.user::canBuild));
        Collections.shuffle(blocks);
        return blocks;
    }

    private @Nullable BatchProcessor tryCreateBatchProcessor(int batchSize, BlockProcessor processor, Collection<Block> blocks) {
        BatchProcessor result = new BatchProcessor(this.user, new ArrayDeque<Block>(), batchSize, processor);
        return result.fillQueue(blocks) ? result : null;
    }

    private static boolean isExtinguishable(Block block) {
        return MaterialUtil.isFire(block) || MaterialUtil.isCampfire(block) || BlockTag.CANDLES.isTagged(block);
    }

    public static boolean canBurn(User user) {
        AbilityDescription selected = user.selectedAbility();
        if (selected == null) {
            return true;
        }
        return !user.hasAbilitySelected("HeatControl") || !user.canBend(selected);
    }

    public static void toggleMode(User user) {
        if (user.hasAbilitySelected("heatcontrol") && user.store().canEdit(KEY)) {
            Mode mode = user.store().toggle(KEY, Mode.COOLING);
            user.sendActionBar((Component)Component.text((String)("Mode: " + mode.name()), (TextColor)ColorPalette.TEXT_COLOR));
        }
    }

    private static enum Mode {
        COOLING,
        HEATING;

    }

    private static interface HeatControlState
    extends Updatable {
        public void onDestroy();

        public boolean shouldAddCooldown();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 2000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 10.0;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 5.0;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long chargeTime = 1500L;
        @Modifiable(value=Attribute.RANGE)
        private double solidifyRange = 5.0;
        @Modifiable(value=Attribute.RADIUS)
        private double solidifyRadius = 6.0;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long cookInterval = 2000L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "heatcontrol");
        }
    }

    @FunctionalInterface
    private static interface BlockProcessor {
        public boolean accept(User var1, Block var2);
    }

    private record BatchProcessor(User user, Queue<Block> queue, int batchSize, BlockProcessor blockProcessor) implements BatchQueue<Block>,
    HeatControlState
    {
        @Override
        public boolean process(Block block) {
            if (!TempBlock.isBendable(block)) {
                return false;
            }
            return this.blockProcessor.accept(this.user, block);
        }

        @Override
        public Updatable.UpdateResult update() {
            this.processQueue(this.batchSize);
            return this.isEmpty() ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
        }

        @Override
        public void onDestroy() {
            this.queue.clear();
        }

        @Override
        public boolean shouldAddCooldown() {
            return !this.isEmpty();
        }
    }

    private static final class Heating
    implements HeatControlState {
        private final User user;
        private final long cookInterval;
        private final long fullyChargedTime;
        private long lastCookTime;
        private boolean requireSneak;
        private boolean charged;
        private TempLight light;
        private int ticks = 3;

        private Heating(User user, long cookInterval, long chargeTime) {
            this.user = user;
            this.cookInterval = cookInterval;
            this.lastCookTime = System.currentTimeMillis();
            this.fullyChargedTime = this.lastCookTime + chargeTime;
            this.requireSneak = true;
            this.charged = false;
        }

        @Override
        public Updatable.UpdateResult update() {
            long time = System.currentTimeMillis();
            boolean sneaking = this.user.sneaking();
            if (!this.charged && time >= this.fullyChargedTime) {
                this.charged = true;
            }
            if (this.charged && this.requireSneak && !sneaking) {
                this.requireSneak = false;
            }
            if (sneaking != this.requireSneak || this.user.underWater()) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (time > this.lastCookTime + this.cookInterval && this.cook()) {
                this.lastCookTime = time;
            }
            Vector3d handLoc = this.user.mainHandSide();
            if (this.charged) {
                ParticleBuilder.fire(this.user, handLoc).spawn(this.user.world());
                this.createLight(this.user.eyeBlock());
            } else {
                Particle particle = ThreadLocalRandom.current().nextInt(5) == 0 ? Particle.SMALL_FLAME : Particle.SMOKE;
                particle.builder(handLoc).spawn(this.user.world());
            }
            this.user.editProperty(EntityProperties.FREEZE_TICKS, freezeTicks -> freezeTicks - 2);
            return Updatable.UpdateResult.CONTINUE;
        }

        @Override
        public void onDestroy() {
            if (this.light != null) {
                this.light.unlock();
                this.light = null;
            }
        }

        @Override
        public boolean shouldAddCooldown() {
            return false;
        }

        private boolean cook() {
            Inventory inventory = this.user.inventory();
            if (inventory instanceof PlayerInventory) {
                PlayerInventory inv = (PlayerInventory)inventory;
                ItemSnapshot uncooked = inv.itemInMainHand();
                ItemSnapshot cooked = Platform.instance().factory().campfireRecipeCooked(uncooked.type()).orElse(null);
                if (cooked != null && inv.remove(uncooked.type())) {
                    inv.offer(cooked);
                    return true;
                }
            }
            return false;
        }

        private void createLight(Block block) {
            if (this.light != null && !this.light.block().equals(block)) {
                this.light.unlock();
            }
            this.light = TempLight.builder(++this.ticks).rate(2).duration(0L).build(block).map(TempLight::lock).orElse(null);
        }
    }
}

