/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.SimpleAbility;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;

public class FireBreath
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final ExpiringSet<UUID> affectedEntities = new ExpiringSet(500L);
    private final MultiUpdatable<FireStream> streams = MultiUpdatable.empty();

    public FireBreath(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, FireBreath.class)) {
            return false;
        }
        if (Policies.UNDER_WATER.test(user, this.description()) || Policies.UNDER_LAVA.test(user, this.description())) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).add(ExpireRemovalPolicy.of(this.userConfig.duration)).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        Vector3d offset = Vector3d.of(0.0, -0.1, 0.0);
        Ray ray = Ray.of((Vector3d)this.user.eyeLocation().add(offset), (Vector3d)this.user.direction().multiply(this.userConfig.range));
        this.streams.add(new FireStream(ray));
        return this.streams.update();
    }

    @Override
    public void onDestroy() {
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(SimpleAbility::collider).toList();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 12000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 9.0;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 2000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 0.75;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "firebreath");
        }
    }

    private class FireStream
    extends ParticleStream {
        private static final double ORIGINAL_COLLISION_RADIUS = 0.5;
        private int ticks;

        public FireStream(Ray ray) {
            super(FireBreath.this.user, ray, 0.4, 0.5);
            this.ticks = 3;
            this.canCollide = t -> t.isLiquid() || t == BlockType.SNOW;
        }

        @Override
        public void render(Vector3d location) {
            double offset = 0.2 * this.distanceTravelled;
            this.collisionRadius = 0.5 + offset;
            ParticleBuilder.fire(FireBreath.this.user, location).count(FastMath.ceil(0.75 * this.distanceTravelled)).offset(offset).extra(0.02).spawn(FireBreath.this.user.world());
            TempLight.builder(++this.ticks).build(FireBreath.this.user.world().blockAt(location));
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(3) == 0) {
                SoundEffect.FIRE.play(FireBreath.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            BendingEffect.FIRE_TICK.apply(FireBreath.this.user, entity);
            if (FireBreath.this.affectedEntities.add(entity.uuid())) {
                entity.damage(FireBreath.this.userConfig.damage, FireBreath.this.user, FireBreath.this.description());
            }
            return false;
        }

        @Override
        public boolean onBlockHit(Block block) {
            if (WorldUtil.tryMelt(FireBreath.this.user, block)) {
                return true;
            }
            Block above = block.offset(Direction.UP);
            if (MaterialUtil.isIgnitable(above) && FireBreath.this.user.canBuild(above)) {
                TempBlock.fire().duration(BendingProperties.instance().fireRevertTime()).ability(FireBreath.this).build(above);
            }
            return true;
        }
    }
}

