/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Explosive;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingExplosion;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.common.ability.fire.FireShield;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class Combustion
extends AbilityInstance
implements Explosive {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private CombustBeam beam;
    private Collider ignoreCollider;
    private boolean exploded;

    public Combustion(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.ATTACK) {
            user.game().abilityManager(user.worldKey()).userInstances(user, Combustion.class).forEach(Combustion::explode);
            return false;
        }
        if (user.onCooldown(this.description())) {
            return false;
        }
        if (Policies.UNDER_WATER.test(user, this.description()) || Policies.UNDER_LAVA.test(user, this.description())) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.beam = new CombustBeam();
        this.removalPolicy = Policies.defaults();
        user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.exploded || this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.beam.update();
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.beam.collider());
    }

    @Override
    public void onCollision(Collision collision) {
        Ability collidedAbility = collision.collidedAbility();
        if (collidedAbility instanceof FireShield) {
            FireShield fireShield = (FireShield)collidedAbility;
            if (fireShield.isSphere()) {
                this.ignoreCollider = collision.colliderOther();
            }
            this.explode();
        } else if (collidedAbility instanceof Combustion) {
            Combustion other = (Combustion)collidedAbility;
            Vector3d first = collision.colliderSelf().position();
            Vector3d second = collision.colliderOther().position();
            Vector3d center = (Vector3d)((Vector3d)first.add(second)).multiply(0.5);
            this.createExplosion(center, this.userConfig.power + other.userConfig.power, this.userConfig.damage + other.userConfig.damage);
            other.exploded = true;
        } else if (collidedAbility instanceof Explosive) {
            this.explode();
        } else if (collidedAbility.description().elements().contains((Object)Element.EARTH) && collision.removeSelf()) {
            this.explode();
        }
    }

    @Override
    public void explode() {
        this.createExplosion(this.beam.collider().position(), this.userConfig.power, this.userConfig.damage);
    }

    private void createExplosion(Vector3d center, double size, double damage) {
        if (this.exploded) {
            return;
        }
        this.exploded = true;
        Particle.FLAME.builder(center).extra(0.2).count(20).offset(1.0).spawn(this.user.world());
        Particle.LARGE_SMOKE.builder(center).extra(0.2).count(20).offset(1.0).spawn(this.user.world());
        Particle.FIREWORK.builder(center).extra(0.2).count(20).offset(1.0).spawn(this.user.world());
        Ray ray = Ray.of(center, this.user.direction());
        FragileStructure.tryDamageStructure(this.user.world().nearbyBlocks(center, size), 0, ray);
        BendingExplosion.builder().size(size).damage(damage).fireTicks(this.userConfig.fireTicks).breakBlocks(true).placeFire(true).ignoreInsideCollider(this.ignoreCollider).sound(6.0f, 0.8f).buildAndExplode(this, center);
    }

    private class CombustBeam
    extends ParticleStream {
        private static final SoundEffect LOUD_COMBUSTION = SoundEffect.COMBUSTION.with(2.0f, 0.0f);
        private Vector3d streamDirection;
        private double randomBeamDistance;

        public CombustBeam() {
            super(Combustion.this.user, Combustion.this.user.ray(Combustion.this.userConfig.range), 0.2, 1.0);
            this.randomBeamDistance = 7.0;
            this.canCollide = BlockProperties::isLiquid;
            this.singleCollision = true;
            this.steps = 6;
            this.streamDirection = this.dir;
        }

        @Override
        public void render(Vector3d location) {
            this.renderRing(location);
            Particle.SMOKE.builder(location).spawn(Combustion.this.user.world());
            Particle.WAX_OFF.builder(location).extra(0.005).spawn(Combustion.this.user.world());
        }

        @Override
        protected Vector3d controlDirection() {
            if (Combustion.this.description().equals(Combustion.this.user.selectedAbility())) {
                this.streamDirection = (Vector3d)Combustion.this.user.direction().multiply(this.speed);
            }
            return this.streamDirection;
        }

        private void renderRing(Vector3d location) {
            if (this.distanceTravelled >= this.randomBeamDistance) {
                LOUD_COMBUSTION.play(Combustion.this.user.world(), location);
                this.randomBeamDistance = this.distanceTravelled + 4.0 + 2.0 * ThreadLocalRandom.current().nextGaussian();
                double radius = ThreadLocalRandom.current().nextDouble(3.0, 6.0);
                VectorUtil.circle(Vector3d.ONE, Combustion.this.user.direction(), 20).forEach(v -> Particle.WAX_OFF.builder((Position)location.add((Position)v.multiply(0.2))).count(0).offset((Position)v.multiply(radius)).extra(0.9).spawn(Combustion.this.user.world()));
            }
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(3) == 0) {
                SoundEffect.COMBUSTION.play(Combustion.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            Combustion.this.explode();
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            Combustion.this.explode();
            return true;
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 12000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 4.0;
        @Modifiable(value=Attribute.FIRE_TICKS)
        private int fireTicks = 50;
        @Modifiable(value=Attribute.STRENGTH)
        private double power = 3.4;
        @Modifiable(value=Attribute.RANGE)
        private double range = 48.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "combustion");
        }
    }
}

