/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth.passive;

import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockStateProperties;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.property.Property;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public class FerroControl
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Entity controlledEntity;
    private long nextInteractTime;

    public FerroControl(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description()) || !this.user.canBend(this.description())) {
            this.controlledEntity = null;
            return Updatable.UpdateResult.CONTINUE;
        }
        if (this.controlledEntity == null || !this.controlledEntity.valid()) {
            Entity result = this.user.rayTrace(this.userConfig.entitySelectRange).cast(this.user.world()).entity();
            Entity entity = this.controlledEntity = result != null && result.type() == EntityType.MINECART ? result : null;
        }
        if (this.controlledEntity != null) {
            if (!this.user.canBuild(this.controlledEntity.block())) {
                this.controlledEntity = null;
                return Updatable.UpdateResult.CONTINUE;
            }
            Vector3d targetLocation = (Vector3d)this.user.eyeLocation().add((Position)this.user.direction().multiply(this.userConfig.entityRange));
            Vector3d dir = (Vector3d)targetLocation.subtract(this.controlledEntity.location());
            Vector3d velocity = dir.lengthSq() < 1.0 ? Vector3d.ZERO : (Vector3d)dir.normalize().multiply(this.userConfig.controlSpeed);
            this.controlledEntity.applyVelocity(this, velocity);
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private void act(Block block) {
        if (!this.user.canBend(this.description())) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time < this.nextInteractTime) {
            return;
        }
        this.nextInteractTime = time + this.userConfig.cooldown;
        if (!this.user.canBuild(block)) {
            return;
        }
        BlockState state = block.state();
        Boolean open = (Boolean)state.property(BlockStateProperties.OPEN);
        if (open != null) {
            block.setState((BlockState)state.withProperty((Property)BlockStateProperties.OPEN, Boolean.valueOf(open == false)));
            Sound sound = state.type() == BlockType.IRON_DOOR ? (open == false ? Sound.BLOCK_IRON_DOOR_OPEN : Sound.BLOCK_IRON_DOOR_CLOSE) : (open == false ? Sound.BLOCK_IRON_TRAPDOOR_OPEN : Sound.BLOCK_IRON_TRAPDOOR_CLOSE);
            sound.asEffect(0.5f, 0.0f).play(block);
        }
    }

    public static void act(User user, Block block) {
        if (block.type() == BlockType.IRON_DOOR || block.type() == BlockType.IRON_TRAPDOOR) {
            if (user.sneaking() && FerroControl.mayPlaceBlock(user)) {
                return;
            }
            user.game().abilityManager(user.worldKey()).firstInstance(user, FerroControl.class).ifPresent(ability -> ability.act(block));
        }
    }

    private static boolean mayPlaceBlock(User user) {
        Inventory inv = user.inventory();
        return inv != null && inv.canPlaceBlock();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 500L;
        @Modifiable(value=Attribute.SELECTION)
        private double entitySelectRange = 14.0;
        @Modifiable(value=Attribute.RANGE)
        private double entityRange = 8.0;
        @Modifiable(value=Attribute.SPEED)
        private double controlSpeed = 0.8;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "passives", "ferrocontrol");
        }
    }
}

