/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth.passive;

import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.EntityUtil;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.math.Vector3d;

public class EarthCling
extends AbilityInstance {
    private RemovalPolicy removalPolicy;

    public EarthCling(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).build();
        return true;
    }

    @Override
    public void loadConfig() {
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description()) || !this.user.hasAbilitySelected("earthglove") || this.user.isOnGround()) {
            return Updatable.UpdateResult.CONTINUE;
        }
        if (EntityUtil.isAgainstWall(this.user, b -> EarthMaterials.isEarthbendable(this.user, b) && !b.type().isLiquid())) {
            EntityUtil.tryAddPotion(this.user, PotionEffect.SLOW_FALLING, 10, 0);
            if (!this.user.onCooldown(this.user.selectedAbility())) {
                this.user.applyVelocity(this, Vector3d.ZERO);
                this.user.setProperty(EntityProperties.FALL_DISTANCE, 0.0);
            } else if (this.user.velocity().y() < 0.0) {
                Particle.CRIT.builder(this.user.eyeLocation()).count(2).offset(0.05, 0.4, 0.05).spawn(this.user.world());
                BlockType.STONE.asParticle(this.user.eyeLocation()).count(3).offset(0.1, 0.4, 0.1).spawn(this.user.world());
            }
        }
        return Updatable.UpdateResult.CONTINUE;
    }
}

