/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.item.InventoryUtil;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.PlayerInventory;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.OutOfRangeRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.ability.earth.util.Projectile;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class MetalCable
extends AbilityInstance {
    public static final DataKey<MetalCable> CABLE_KEY = KeyUtil.data("metal-cable", MetalCable.class);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Vector3d location;
    private Entity cable;
    private Attached<?> attached;
    private boolean hasHit = false;
    private int ticks;

    public MetalCable(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        Iterator<MetalCable> iterator;
        if (method == Activation.SNEAK) {
            for (Entity entity : user.world().nearbyEntities(user.eyeLocation(), 3.0, e -> e.type() == EntityType.ARROW)) {
                MetalCable ability = entity.get(CABLE_KEY).orElse(null);
                if (ability == null || user.uuid().equals(ability.user().uuid())) continue;
                ability.remove();
            }
            return false;
        }
        if (method == Activation.ATTACK && (iterator = user.game().abilityManager(user.worldKey()).userInstances(user, MetalCable.class).toList().iterator()).hasNext()) {
            MetalCable cable = iterator.next();
            cable.tryLaunchTarget();
            return false;
        }
        if (user.onCooldown(this.description())) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        return this.launchCable();
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        ++this.ticks;
        if (this.cable == null || !this.cable.valid()) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.location = this.cable.location();
        double distance = this.user.location().distance(this.location);
        if (this.hasHit && !this.handleMovement(distance)) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.visualizeLine(distance) ? Updatable.UpdateResult.CONTINUE : Updatable.UpdateResult.REMOVE;
    }

    private boolean handleMovement(double distance) {
        if (this.attached == null || !this.attached.isValid(this.user)) {
            return false;
        }
        Entity entityToMove = this.user;
        Vector3d targetLocation = this.location;
        AttachedEntity attachedEntity = null;
        Attached<?> attached = this.attached;
        if (attached instanceof AttachedEntity) {
            AttachedEntity temp;
            attachedEntity = temp = (AttachedEntity)attached;
            this.cable.teleport(attachedEntity.handle().location().add(0.0, attachedEntity.offset(), 0.0));
            if (this.user.sneaking()) {
                entityToMove = attachedEntity.handle();
                Ray ray = this.user.ray(distance / 2.0);
                targetLocation = (Vector3d)ray.position().add(ray.direction());
            }
        }
        Vector3d direction = ((Vector3d)targetLocation.subtract(entityToMove.location())).normalize();
        if (distance > 3.0) {
            entityToMove.applyVelocity(this, (Vector3d)direction.multiply(this.userConfig.pullSpeed));
        } else {
            if (attachedEntity != null) {
                entityToMove.applyVelocity(this, Vector3d.ZERO);
                if (attachedEntity.handle().type() == EntityType.FALLING_BLOCK) {
                    Entity entity = attachedEntity.handle();
                    if (entity instanceof TempEntity.TempFallingBlock) {
                        TempEntity.TempFallingBlock fallingBlock = (TempEntity.TempFallingBlock)entity;
                        fallingBlock.state().asParticle(fallingBlock.center()).count(8).offset(0.25, 0.15, 0.25).spawn(this.user.world());
                    }
                    attachedEntity.handle().remove();
                }
                return false;
            }
            if (distance > 1.5) {
                entityToMove.applyVelocity(this, (Vector3d)direction.multiply(0.4 * this.userConfig.pullSpeed));
            } else {
                entityToMove.applyVelocity(this, Vector3d.of(0.0, 0.5, 0.0));
                return false;
            }
        }
        return true;
    }

    private boolean launchCable() {
        if (!this.hasRequiredInv()) {
            return false;
        }
        Vector3d targetLocation = this.user.rayTrace(this.userConfig.range).cast(this.user.world()).entityCenterOrPosition();
        if (this.user.world().blockAt(targetLocation).type().isLiquid()) {
            return false;
        }
        Vector3d origin = this.user.mainHandSide();
        Vector3d dir = ((Vector3d)targetLocation.subtract(origin)).normalize();
        Entity arrow = this.user.shootArrow(origin, dir, 1.8);
        arrow.add(CABLE_KEY, this);
        this.cable = arrow;
        this.location = this.cable.location();
        SoundEffect.METAL.play(this.user.world(), origin);
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(OutOfRangeRemovalPolicy.of(this.userConfig.range, origin, () -> this.location)).build();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    private boolean visualizeLine(double distance) {
        Vector3d origin = this.user.mainHandSide();
        Vector3d dir = (Vector3d)this.location.subtract(origin);
        Block ignore = Optional.ofNullable(this.attached).filter(AttachedBlock.class::isInstance).map(AttachedBlock.class::cast).map(AttachedBlock::handle).orElse(null);
        if (dir.lengthSq() > 0.1 && this.user.rayTrace(origin, dir).ignoreLiquids(false).ignore(ignore).blocks(this.user.world()).hit()) {
            return false;
        }
        int points = FastMath.ceil(distance * 2.0);
        Vector3d offset = (Vector3d)dir.multiply(1.0 / (double)points);
        Vector3d originWithOffset = (Vector3d)origin.add((Position)offset.multiply(0.33 * (double)(this.ticks % 3)));
        for (int i = 0; i < points; ++i) {
            ParticleBuilder.rgb(originWithOffset.add((Position)offset.multiply(i)), "#444444", 0.75f).spawn(this.user.world());
        }
        return true;
    }

    public void hitBlock(Block block) {
        if (this.attached != null) {
            return;
        }
        if (!this.user.canBuild(block)) {
            this.remove();
            return;
        }
        Vector3d dir = ((Vector3d)this.user.eyeLocation().subtract(this.location)).normalize();
        if (this.user.sneaking() && !MaterialUtil.isUnbreakable(block)) {
            BlockState state = block.state();
            TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(block);
            TempEntity.TempFallingBlock entity = ((TempEntity.FallingBlockBuilder)TempEntity.TempFallingBlock.fallingBlock(state).velocity((Vector3d)dir.multiply(0.2))).buildReal(block.world(), this.location);
            Projectile ability = new Projectile(this.user, this.description(), entity, this.userConfig.projectileRange, this.userConfig.damage);
            this.user.game().abilityManager(this.user.worldKey()).addAbility(ability);
            this.attached = new AttachedEntity(entity, 0.5);
        } else {
            dir = dir.negate();
            this.attached = new AttachedBlock(block, block.type());
        }
        FragileStructure.tryDamageStructure(block, 2, Ray.of(this.location, dir));
        this.hasHit = true;
    }

    public void hitEntity(Entity entity) {
        if (this.attached != null || entity.uuid().equals(this.user.uuid())) {
            return;
        }
        if (!this.user.canBuild(entity.block())) {
            this.remove();
            return;
        }
        double offset = Math.clamp(this.cable.location().y() - entity.location().y(), 0.0, entity.height());
        this.attached = new AttachedEntity(entity, offset);
        entity.setProperty(EntityProperties.FALL_DISTANCE, 0.0);
        this.hasHit = true;
    }

    private boolean hasRequiredInv() {
        if (InventoryUtil.hasMetalArmor(this.user)) {
            return true;
        }
        Inventory inventory = this.user.inventory();
        if (inventory instanceof PlayerInventory) {
            PlayerInventory inv = (PlayerInventory)inventory;
            return inv.has(Item.IRON_INGOT) || inv.has(Item.RAW_IRON);
        }
        return false;
    }

    private void remove() {
        this.removalPolicy = (u, d) -> true;
    }

    private void tryLaunchTarget() {
        if (this.attached == null || !this.attached.canLaunch()) {
            return;
        }
        Attached<?> attached = this.attached;
        if (attached instanceof AttachedEntity) {
            AttachedEntity attachedEntity = (AttachedEntity)attached;
            Vector3d targetLocation = this.user.rayTrace(this.userConfig.projectileRange).cast(this.user.world()).entityCenterOrPosition();
            Vector3d velocity = (Vector3d)((Vector3d)targetLocation.subtract(this.location)).normalize().multiply(this.userConfig.launchSpeed);
            attachedEntity.handle().applyVelocity(this, velocity.add(0.0, 0.2, 0.0));
            attachedEntity.handle().setProperty(EntityProperties.FALL_DISTANCE, 0.0);
        }
        this.attached = null;
        this.remove();
    }

    @Override
    public void onDestroy() {
        if (this.cable != null) {
            this.cable.remove();
        }
    }

    @Override
    public Collection<Collider> colliders() {
        Vector3d origin = this.user.mainHandSide();
        Vector3d dir = (Vector3d)this.location.subtract(origin);
        return List.of(Ray.of(origin, dir), Sphere.of(this.location, 0.8));
    }

    public Optional<Entity> electrify(Vector3d pos, boolean directed) {
        Vector3d origin = this.user.mainHandSide();
        Vector3d projected = VectorUtil.closestPoint(origin, this.location, pos);
        Vector3d dirToOrigin = (Vector3d)origin.subtract(projected);
        Vector3d dirToEnd = (Vector3d)this.location.subtract(projected);
        if (directed || dirToOrigin.lengthSq() < dirToEnd.lengthSq()) {
            this.visualizeElectrifiedLine(projected, dirToOrigin);
            return Optional.of(this.user);
        }
        this.visualizeElectrifiedLine(projected, dirToEnd);
        return Optional.ofNullable(this.attached).filter(AttachedEntity.class::isInstance).map(AttachedEntity.class::cast).map(AttachedEntity::handle);
    }

    private void visualizeElectrifiedLine(Vector3d origin, Vector3d direction) {
        int points = FastMath.ceil(direction.length() * 4.0);
        Vector3d offset = (Vector3d)direction.multiply(1.0 / (double)points);
        for (int i = 0; i < points; ++i) {
            Vector3d v = (Vector3d)origin.add((Position)offset.multiply(i));
            Particle.WAX_OFF.builder(v).offset(0.05).spawn(this.user.world());
            if (ThreadLocalRandom.current().nextInt(6) != 0) continue;
            SoundEffect.LIGHTNING.play(this.user.world(), v);
            Particle.ELECTRIC_SPARK.builder(v).offset(0.1).count(5).spawn(this.user.world());
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 4500L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 20.0;
        @Modifiable(value=Attribute.RANGE)
        private double projectileRange = 48.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.5;
        @Modifiable(value=Attribute.SPEED)
        private double pullSpeed = 0.9;
        @Modifiable(value=Attribute.SPEED)
        private double launchSpeed = 1.6;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "metalcable");
        }
    }

    private static interface Attached<T> {
        public T handle();

        public boolean isValid(User var1);

        default public boolean canLaunch() {
            return true;
        }
    }

    private static final class AttachedEntity
    extends Record
    implements Attached<Entity> {
        private final Entity handle;
        private final double offset;

        private AttachedEntity(Entity handle, double offset) {
            this.handle = handle;
            this.offset = offset;
        }

        @Override
        public boolean isValid(User user) {
            return this.handle.valid() && this.handle.world().equals(user.world());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AttachedEntity.class, "handle;offset", "handle", "offset"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AttachedEntity.class, "handle;offset", "handle", "offset"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AttachedEntity.class, "handle;offset", "handle", "offset"}, this, o);
        }

        @Override
        public Entity handle() {
            return this.handle;
        }

        public double offset() {
            return this.offset;
        }
    }

    private static final class AttachedBlock
    extends Record
    implements Attached<Block> {
        private final Block handle;
        private final BlockType material;

        private AttachedBlock(Block handle, BlockType material) {
            this.handle = handle;
            this.material = material;
        }

        @Override
        public boolean isValid(User user) {
            return this.handle.type() == this.material;
        }

        @Override
        public boolean canLaunch() {
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AttachedBlock.class, "handle;material", "handle", "material"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AttachedBlock.class, "handle;material", "handle", "material"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AttachedBlock.class, "handle;material", "handle", "material"}, this, o);
        }

        @Override
        public Block handle() {
            return this.handle;
        }

        public BlockType material() {
            return this.material;
        }
    }
}

