/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.Fracture;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.basic.BlockLine;
import me.moros.bending.api.ability.common.basic.MovementResolver;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class LavaFlux
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Collection<Block> collisionBases = new HashSet<Block>();
    private Line line;

    public LavaFlux(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        return this.release();
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.line.update() == Updatable.UpdateResult.REMOVE) {
            this.checkWallCollisions();
            return Updatable.UpdateResult.REMOVE;
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private void checkWallCollisions() {
        if (!this.line.collided) {
            return;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block block : this.collisionBases) {
            Block temp;
            int i = 0;
            while ((double)i <= this.userConfig.wallRadius && this.canDestroyBlock(temp = block.offset(Direction.UP, i))) {
                blocks.add(temp);
                ++i;
            }
        }
        Fracture fracture = Fracture.builder().fragile(FragileStructure.builder().fallingBlocks(true).health(1).predicate(b -> b.type() == BlockType.MAGMA_BLOCK)).interval(70L).add(blocks).build();
        if (fracture != null) {
            this.user.game().abilityManager(this.user.worldKey()).addUpdatable(fracture);
        }
    }

    private boolean canDestroyBlock(Block block) {
        if (EarthMaterials.isMetalBendable(block) || !this.user.canBuild(block)) {
            return false;
        }
        return this.line.checkDistance(block) && EarthMaterials.isEarthbendable(this.user, block);
    }

    private boolean release() {
        if (!this.user.isOnGround()) {
            return false;
        }
        Vector3d center = this.user.location().center();
        Vector3d dir = (Vector3d)((Vector3d)this.user.direction().withY(0.0)).normalize().multiply(this.userConfig.range + 2.0);
        this.line = new Line(Ray.of(center, dir), 70L);
        if (this.line.update() == Updatable.UpdateResult.REMOVE) {
            return false;
        }
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).build();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 10000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 9.0;
        @Modifiable(value=Attribute.RADIUS)
        private int width = 3;
        @Modifiable(value=Attribute.STRENGTH)
        private double wallRadius = 5.0;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 8000L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "lavaflux");
        }
    }

    private class Line
    extends BlockLine {
        private final Collection<BlockLine.Vector2i> affectedBlocks;
        private final Vector3d face;
        private final int offset;
        private final int wallOffset;
        private boolean center;
        private boolean collided;

        public Line(Ray ray, long interval) {
            super(LavaFlux.this.user, ray);
            this.affectedBlocks = new HashSet<BlockLine.Vector2i>();
            this.center = true;
            this.interval = interval;
            this.face = VectorUtil.nearestFace(LavaFlux.this.user.direction().cross(Vector3d.PLUS_J));
            int w = Math.max(3, LavaFlux.this.userConfig.width);
            this.offset = w % 2 == 0 ? w / 2 : (w - 1) / 2;
            w = Math.max(w, FastMath.ceil(LavaFlux.this.userConfig.wallRadius));
            this.wallOffset = w % 2 == 0 ? w / 2 : (w - 1) / 2;
            this.diagonalMovement = false;
        }

        @Override
        public boolean isValidBlock(Block block) {
            if (!MaterialUtil.isTransparent(block) && !EarthMaterials.isLavaBendable(block)) {
                return false;
            }
            Block below = block.offset(Direction.DOWN);
            if (EarthMaterials.isMetalBendable(below)) {
                return false;
            }
            return EarthMaterials.isEarthbendable(LavaFlux.this.user, below);
        }

        @Override
        public void render(Block block) {
            this.render(block, this.offset, this.offset);
            this.center = true;
        }

        private void render(Block block, int left, int right) {
            this.center = false;
            if (!this.affectedBlocks.add(BlockLine.Vector2i.at(block.blockX(), block.blockZ()))) {
                return;
            }
            WorldUtil.tryBreakPlant(block);
            if (MaterialUtil.isFire(block)) {
                block.setType(BlockType.AIR);
            }
            Block below = block.offset(Direction.DOWN);
            TempBlock.builder(MaterialUtil.lavaData(1)).duration(150L).ability(LavaFlux.this).build(block);
            long delay = ThreadLocalRandom.current().nextLong(1500L);
            TempBlock.builder(BlockType.STONE).duration(LavaFlux.this.userConfig.duration + delay).build(below);
            TempBlock.builder(BlockType.MAGMA_BLOCK).duration(LavaFlux.this.userConfig.duration).ability(LavaFlux.this).build(below);
            if (ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.LAVA.play(block);
            }
            if (left > 0) {
                this.expand(block, this.face, left - 1, 0);
            }
            if (right > 0) {
                this.expand(block, this.face.negate(), 0, right - 1);
            }
        }

        private void expand(Block base, Vector3d side, int left, int right) {
            MovementResolver.Resolved resolved = this.resolve(base.center(), side);
            Block block = LavaFlux.this.user.world().blockAt(resolved.point());
            if (resolved.success()) {
                this.render(block, left, right);
            } else {
                LavaFlux.this.collisionBases.add(block);
            }
        }

        private void resolveOnly(Vector3d point, Vector3d side, int amount) {
            MovementResolver.Resolved resolved;
            if (amount > 0 && !(resolved = this.resolve(point, side)).success()) {
                this.resolveOnly(resolved.point(), side, amount - 1);
            }
        }

        @Override
        public void onCollision(Vector3d collided) {
            Block block = LavaFlux.this.user.world().blockAt(collided);
            if (!this.checkDistance(block)) {
                return;
            }
            this.collided = true;
            if (this.center) {
                this.center = false;
                this.resolveOnly(collided, this.face, this.wallOffset);
                this.resolveOnly(collided, this.face.negate(), this.wallOffset);
            }
            if (MaterialUtil.isWater(block)) {
                WorldUtil.playLavaExtinguishEffect(block);
                TempBlock.builder(BlockType.OBSIDIAN).duration(BendingProperties.instance().earthRevertTime(1000L)).build(block);
                return;
            }
            LavaFlux.this.collisionBases.add(block);
        }

        private boolean checkDistance(Block block) {
            return block.center().distanceSq(this.location) < LavaFlux.this.userConfig.wallRadius * LavaFlux.this.userConfig.wallRadius;
        }
    }
}

