/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.EarthSpike;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.SelectedSource;
import me.moros.bending.api.ability.common.basic.AbstractLine;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.display.BlockDisplayBuilder;
import me.moros.bending.api.platform.entity.display.Transformation;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.TempDisplayEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;

public class EarthLine
extends AbilityInstance {
    private static final DataKey<Mode> KEY = KeyUtil.data("earthline-mode", Mode.class);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private StateChain states;
    private Line earthLine;

    public EarthLine(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.ATTACK) {
            user.game().abilityManager(user.worldKey()).firstInstance(user, EarthLine.class).ifPresent(EarthLine::launch);
            return false;
        }
        if (user.onCooldown(this.description())) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        Block source = user.find(this.userConfig.selectRange, b -> EarthMaterials.isEarthNotLava(user, b));
        if (source == null || !MaterialUtil.isTransparent(source.offset(Direction.UP))) {
            return false;
        }
        BlockState fakeData = MaterialUtil.focusedType(source.type()).defaultState();
        Optional<EarthLine> line = user.game().abilityManager(user.worldKey()).firstInstance(user, EarthLine.class);
        if (line.isPresent()) {
            State state = line.get().states.current();
            if (state instanceof SelectedSource.WithState) {
                SelectedSource.WithState selectedSource = (SelectedSource.WithState)state;
                selectedSource.reselect(source, fakeData);
            }
            return false;
        }
        this.states = new StateChain().addState(SelectedSource.create(user, source, this.userConfig.selectRange, fakeData)).start();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.earthLine != null) {
            this.earthLine.controllable(this.user.sneaking());
            return this.earthLine.update();
        }
        return this.states.update();
    }

    private void launch() {
        if (this.earthLine != null) {
            this.earthLine.raiseSpikes();
            return;
        }
        State state = this.states.current();
        if (state instanceof SelectedSource) {
            state.complete();
            Block source = this.states.chainStore().stream().findAny().orElse(null);
            if (source != null) {
                Mode mode = this.user.store().get(KEY).orElse(Mode.NORMAL);
                this.earthLine = new Line(source, mode);
                this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
                this.user.addCooldown(this.description(), this.userConfig.cooldown);
            }
        }
    }

    public static void switchMode(User user) {
        if (user.hasAbilitySelected("earthline") && user.store().canEdit(KEY)) {
            Mode mode = user.store().toggle(KEY, Mode.NORMAL);
            user.sendActionBar((Component)Component.text((String)("Mode: " + mode.name()), (TextColor)ColorPalette.TEXT_COLOR));
        }
    }

    @Override
    public void onDestroy() {
        State state = this.states.current();
        if (state instanceof SelectedSource) {
            SelectedSource selectedSource = (SelectedSource)state;
            selectedSource.onDestroy();
        }
    }

    @Override
    public Collection<Collider> colliders() {
        return this.earthLine == null ? List.of() : List.of(this.earthLine.collider());
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 5000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 20.0;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 6.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 1.1;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockup = 0.55;
        @Modifiable(value=Attribute.DURATION)
        private long prisonDuration = 1500L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "earthline");
        }
    }

    private class Line
    extends AbstractLine {
        private final Mode mode;
        private boolean raisedSpikes;
        private boolean imprisoned;

        public Line(Block source, Mode mode) {
            super(EarthLine.this.user, source, EarthLine.this.userConfig.range, 0.8, false);
            this.raisedSpikes = false;
            this.imprisoned = false;
            this.mode = mode;
        }

        @Override
        public void render(Vector3d location) {
            double x = ThreadLocalRandom.current().nextDouble(-0.125, 0.125);
            double z = ThreadLocalRandom.current().nextDouble(-0.125, 0.125);
            int blockLight = EarthLine.this.user.world().blockLightLevel(location);
            int skyLight = EarthLine.this.user.world().skyLightLevel(location);
            BlockState type = EarthLine.this.user.world().blockAt(location).offset(Direction.DOWN).state();
            ((TempDisplayEntity.Builder)((TempDisplayEntity.Builder)((TempDisplayEntity.Builder)TempDisplayEntity.builder(type).gravity(true)).duration(700L)).velocity(Vector3d.of(0.0, 0.2, 0.0))).edit(d -> ((BlockDisplayBuilder)d.transformation(Transformation.scaled(0.75))).brightness(blockLight, skyLight)).build(EarthLine.this.user.world(), location.add(x, -0.75, z));
            type.asParticle(location).count(6).offset(0.25, 0.125, 0.25).spawn(EarthLine.this.user.world());
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(5) == 0) {
                SoundEffect.EARTH.play(EarthLine.this.user.world(), location);
            }
            if (this.raisedSpikes || this.imprisoned) {
                EarthLine.this.removalPolicy = (u, d) -> true;
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            switch (this.mode.ordinal()) {
                case 0: {
                    this.raiseSpikes();
                    break;
                }
                case 1: {
                    this.imprisonTarget((LivingEntity)entity);
                    return true;
                }
            }
            entity.damage(EarthLine.this.userConfig.damage, EarthLine.this.user, EarthLine.this.description());
            Vector3d velocity = (Vector3d)((Vector3d)this.direction.withY(EarthLine.this.userConfig.knockup)).normalize().multiply(EarthLine.this.userConfig.knockback);
            entity.applyVelocity(EarthLine.this, velocity);
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            return false;
        }

        @Override
        protected boolean isValidBlock(Block block) {
            if (!MaterialUtil.isTransparent(block)) {
                return false;
            }
            Block below = block.offset(Direction.DOWN);
            if (EarthMaterials.isLavaBendable(below) || EarthMaterials.isMetalBendable(below)) {
                return false;
            }
            return EarthMaterials.isEarthbendable(EarthLine.this.user, below);
        }

        @Override
        protected void onCollision(Vector3d point) {
            FragileStructure.tryDamageStructure(EarthLine.this.user.world().blockAt(point), 5, Ray.of(this.collider.position(), this.direction));
        }

        public void raiseSpikes() {
            if (this.mode != Mode.NORMAL || this.raisedSpikes) {
                return;
            }
            this.raisedSpikes = true;
            Vector3d loc = (Vector3d)this.collider.position().add(Vector3d.MINUS_J);
            MultiUpdatable<EarthSpike> spikes = MultiUpdatable.builder().add(new EarthSpike(EarthLine.this.user.world().blockAt(loc), 1, false)).add(new EarthSpike(EarthLine.this.user.world().blockAt((Position)loc.add(this.direction)), 2, true)).build();
            EarthLine.this.user.game().abilityManager(EarthLine.this.user.worldKey()).addUpdatable(spikes);
        }

        private void imprisonTarget(LivingEntity entity) {
            if (this.imprisoned || !entity.valid() || entity.distanceAboveGround(2.0) > 1.2) {
                return;
            }
            BlockType material = null;
            Block blockToCheck = entity.block().offset(Direction.DOWN);
            if (EarthMaterials.isEarthbendable(EarthLine.this.user, blockToCheck)) {
                material = blockToCheck.type() == BlockType.GRASS_BLOCK ? BlockType.DIRT : blockToCheck.type();
            } else {
                for (Block block : EarthLine.this.user.world().nearbyBlocks(blockToCheck.center(), 1.0, b -> EarthMaterials.isEarthbendable(EarthLine.this.user, b), 1)) {
                    material = block.type() == BlockType.GRASS_BLOCK ? BlockType.DIRT : block.type();
                }
            }
            if (material == null) {
                return;
            }
            this.imprisoned = true;
            entity.applyVelocity(EarthLine.this, Vector3d.MINUS_J);
            Vector3d center = entity.location().add(0.0, -0.2, 0.0);
            Vector3d offset = Vector3d.of(0.0, 0.6, 0.0);
            int blockLight = EarthLine.this.user.world().blockLightLevel(blockToCheck);
            int skyLight = EarthLine.this.user.world().skyLightLevel(blockToCheck);
            TempDisplayEntity.Builder builder = (TempDisplayEntity.Builder)TempDisplayEntity.builder(material).edit(c -> c.brightness(blockLight, skyLight)).duration(EarthLine.this.userConfig.prisonDuration);
            VectorUtil.circle((Vector3d)Vector3d.PLUS_I.multiply(0.8), Vector3d.PLUS_J, 8).forEach(v -> {
                builder.build(EarthLine.this.user.world(), (Vector3d)center.add((Position)v));
                builder.build(EarthLine.this.user.world(), (Vector3d)((Vector3d)center.add(offset)).add((Position)v));
            });
            ActionLimiter.builder().duration(EarthLine.this.userConfig.prisonDuration).build(EarthLine.this.user, entity);
        }

        public void controllable(boolean value) {
            this.controllable = value;
        }
    }

    private static enum Mode {
        NORMAL,
        PRISON;

    }
}

