/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.EntityUtil;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempArmor;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;

public class EarthArmor
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Mode mode;
    private TempEntity.TempFallingBlock temp;
    private BlockState data;
    private boolean formed = false;
    private int resistance;

    public EarthArmor(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, EarthArmor.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        Block source = user.find(this.userConfig.selectRange, b -> EarthMaterials.isEarthNotLava(user, b));
        if (source == null) {
            return false;
        }
        if (EarthMaterials.isMetalBendable(source)) {
            this.mode = source.type() == BlockType.GOLD_BLOCK ? Mode.GOLD : Mode.IRON;
            this.resistance = this.userConfig.metalPower;
            SoundEffect.METAL.play(source);
        } else {
            this.mode = Mode.ROCK;
            this.resistance = this.userConfig.power;
            SoundEffect.EARTH.play(source);
        }
        this.data = source.state();
        TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(source);
        this.temp = ((TempEntity.FallingBlockBuilder)((TempEntity.FallingBlockBuilder)((TempEntity.FallingBlockBuilder)TempEntity.fallingBlock(this.data).velocity(Vector3d.of(0.0, 0.2, 0.0))).gravity(false)).duration(10000L)).buildReal(source);
        this.removalPolicy = Policies.builder().add(ExpireRemovalPolicy.of(5000L)).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.formed) {
            return Updatable.UpdateResult.CONTINUE;
        }
        return this.moveBlock() ? Updatable.UpdateResult.CONTINUE : Updatable.UpdateResult.REMOVE;
    }

    private void formArmor() {
        TempArmor.Builder armorBuilder;
        if (this.formed) {
            return;
        }
        switch (this.mode.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                TempArmor.Builder builder = TempArmor.leather();
                break;
            }
            case 1: {
                TempArmor.Builder builder = TempArmor.iron();
                break;
            }
            case 2: {
                TempArmor.Builder builder = armorBuilder = TempArmor.gold();
            }
        }
        if (armorBuilder.duration(this.userConfig.duration).build(this.user).isEmpty()) {
            this.removalPolicy = (u, d) -> true;
            return;
        }
        int duration = FastMath.round((double)this.userConfig.duration / 50.0);
        EntityUtil.tryAddPotion(this.user, PotionEffect.RESISTANCE, duration, this.resistance - 1);
        this.removalPolicy = Policies.builder().add(ExpireRemovalPolicy.of(this.userConfig.duration)).build();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        this.formed = true;
    }

    private boolean moveBlock() {
        double speedFactor;
        if (!this.temp.valid()) {
            return false;
        }
        Vector3d center = this.temp.center();
        Block currentBlock = this.user.world().blockAt(center);
        WorldUtil.tryBreakPlant(currentBlock);
        if (!(currentBlock.type().isLiquid() || MaterialUtil.isAir(currentBlock) || EarthMaterials.isEarthbendable(this.user, currentBlock))) {
            return false;
        }
        double distanceSquared = this.user.eyeLocation().distanceSq(center);
        double d = speedFactor = distanceSquared > this.userConfig.selectRange * this.userConfig.selectRange ? 1.5 : 0.8;
        if (distanceSquared < 0.5) {
            this.temp.revert();
            this.formArmor();
            return true;
        }
        Vector3d dir = (Vector3d)((Vector3d)this.user.eyeLocation().subtract(center)).normalize().multiply(speedFactor);
        this.temp.applyVelocity(this, dir);
        return true;
    }

    @Override
    public void onDestroy() {
        Vector3d center;
        if (!this.formed && this.temp != null) {
            center = this.temp.center();
            this.temp.revert();
        } else {
            center = this.user.eyeLocation();
        }
        this.user.removePotion(PotionEffect.RESISTANCE);
        this.data.type().soundGroup().breakSound().asEffect(2.0f, 1.0f).play(this.user.world(), center);
        this.data.asParticle(center).count(8).offset(0.5).spawn(this.user.world());
    }

    public static boolean hasArmor(User user) {
        return user.game().abilityManager(user.worldKey()).firstInstance(user, EarthArmor.class).map(e -> e.formed).orElse(false);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 20000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 12000L;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 8.0;
        @Modifiable(value=Attribute.STRENGTH)
        private int power = 2;
        @Modifiable(value=Attribute.STRENGTH)
        private int metalPower = 3;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "eartharmor");
        }
    }

    private static enum Mode {
        ROCK,
        IRON,
        GOLD;

    }
}

