/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.avatar;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.common.ability.avatar.Chakra;
import me.moros.math.FastMath;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;

public class ChakraFocus
implements Updatable {
    private static final int TOTAL_TICKS = 60;
    private static final int VALID_TICK_RANGE = 10;
    private final User user;
    private final Map<Chakra, ChakraData> chakras;
    private final BossBar bar;
    private final int duration;
    private int ticks;

    public ChakraFocus(User user) {
        this.user = user;
        this.duration = 60;
        this.chakras = new EnumMap<Chakra, ChakraData>(Chakra.class);
        this.initChakras();
        this.bar = BossBar.bossBar((Component)this.buildName(), (float)0.0f, (BossBar.Color)BossBar.Color.PURPLE, (BossBar.Overlay)BossBar.Overlay.NOTCHED_10);
    }

    private void initChakras() {
        for (Chakra chakra : Chakra.VALUES) {
            this.chakras.put(chakra, new ChakraData(this.duration, false));
        }
        ElementSet boundElements = ElementSet.mutable();
        this.user.slots().forEach((desc, idx) -> {
            if (desc.elements().size() == 1) {
                boundElements.add(desc.elements().iterator().next());
            }
        });
        boundElements.forEach(e -> this.chakras.get((Object)Chakra.elementalChakra(e)).open());
    }

    private Component buildName() {
        List<Component> names = this.chakras.entrySet().stream().map(e -> this.formatChakraName((Chakra)((Object)((Object)e.getKey())), (ChakraData)e.getValue())).toList();
        Component joinedNames = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.text((String)" - ")), names);
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().color(ColorPalette.NEUTRAL)).append(joinedNames)).build();
    }

    private Component formatChakraName(Chakra chakra, ChakraData focus) {
        TextColor color = ColorPalette.NEUTRAL;
        if (focus.isOpen()) {
            color = chakra.displayName().color();
        } else if (focus.isFocused(this.ticks)) {
            color = ColorPalette.ACCENT;
        }
        return chakra.displayName().color(color);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (!this.user.sneaking() || this.ticks >= this.duration) {
            return Updatable.UpdateResult.REMOVE;
        }
        float factor = Math.clamp((float)this.ticks / (float)this.duration, 0.0f, 1.0f);
        this.bar.name(this.buildName()).progress(factor);
        if (this.ticks++ == 0) {
            this.user.showBossBar(this.bar);
        }
        this.notifyChakraFocus();
        return Updatable.UpdateResult.CONTINUE;
    }

    private void notifyChakraFocus() {
        for (ChakraData chakra : this.chakras.values()) {
            if (chakra.isOpen() || !chakra.isTargetTick(this.ticks)) continue;
            this.user.playSound(Sound.ENTITY_EXPERIENCE_ORB_PICKUP.asEffect().sound());
            return;
        }
    }

    FocusResult tryFocus() {
        boolean focused = false;
        int opened = 0;
        for (ChakraData chakra : this.chakras.values()) {
            if (!chakra.isOpen() && chakra.isFocused(this.ticks)) {
                chakra.open();
                focused = true;
            }
            if (!chakra.isOpen()) continue;
            ++opened;
        }
        if (focused) {
            return opened == this.chakras.size() ? FocusResult.SUCCESS : FocusResult.PARTIAL;
        }
        return FocusResult.FAIL;
    }

    Set<Chakra> getOpenChakras() {
        return this.chakras.entrySet().stream().filter(e -> ((ChakraData)e.getValue()).isOpen()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    void onRemove() {
        this.user.hideBossBar(this.bar);
    }

    private static final class ChakraData {
        private final int targetTick;
        private boolean open;

        private ChakraData(int duration, boolean open) {
            this.targetTick = FastMath.round((double)duration * 0.1 * (double)ThreadLocalRandom.current().nextInt(1, 9));
            this.open = open;
        }

        public boolean isFocused(int tick) {
            return tick >= this.targetTick && tick <= this.targetTick + 10;
        }

        public boolean isTargetTick(int tick) {
            return tick == this.targetTick;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void open() {
            this.open = true;
        }
    }

    static enum FocusResult {
        FAIL,
        PARTIAL,
        SUCCESS;

    }
}

