/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.avatar;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.config.attribute.Modifier;
import me.moros.bending.api.config.attribute.ModifierOperation;
import me.moros.bending.api.config.attribute.ModifyPolicy;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.Cooldown;
import me.moros.bending.api.temporal.Temporary;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingBar;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.common.ability.avatar.Chakra;
import me.moros.bending.common.ability.avatar.ChakraFocus;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;

public class AvatarState
extends AbilityInstance {
    private static final Key AVATAR_MODIFIER_KEY = KeyUtil.simple("avatar-modifier");
    private static final Map<Attribute, Modifier> AVATAR_MODIFIERS = Map.ofEntries(Map.entry(Attribute.RANGE, Modifier.of(ModifierOperation.SUMMED_MULTIPLICATIVE, 0.25)), Map.entry(Attribute.SELECTION, Modifier.of(ModifierOperation.SUMMED_MULTIPLICATIVE, 0.25)), Map.entry(Attribute.STRENGTH, Modifier.of(ModifierOperation.SUMMED_MULTIPLICATIVE, 0.25)), Map.entry(Attribute.COOLDOWN, Modifier.of(ModifierOperation.MULTIPLICATIVE, 0.5)), Map.entry(Attribute.CHARGE_TIME, Modifier.of(ModifierOperation.MULTIPLICATIVE, 0.5)), Map.entry(Attribute.DAMAGE, Modifier.of(ModifierOperation.MULTIPLICATIVE, 2.0)), Map.entry(Attribute.RADIUS, Modifier.of(ModifierOperation.MULTIPLICATIVE, 2.0)), Map.entry(Attribute.HEIGHT, Modifier.of(ModifierOperation.MULTIPLICATIVE, 2.0)), Map.entry(Attribute.AMOUNT, Modifier.of(ModifierOperation.MULTIPLICATIVE, 3.0)), Map.entry(Attribute.FIRE_TICKS, Modifier.of(ModifierOperation.MULTIPLICATIVE, 2.0)), Map.entry(Attribute.FREEZE_TICKS, Modifier.of(ModifierOperation.MULTIPLICATIVE, 2.0)));
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private ChakraFocus chakraFocus;
    private BendingBar durationBar;
    private AvatarModifyPolicy avatarPolicy;
    private long cooldown;

    public AvatarState(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        AvatarState instance = user.game().abilityManager(user.worldKey()).firstInstance(user, AvatarState.class).orElse(null);
        if (method == Activation.ATTACK) {
            if (instance != null) {
                instance.onClick();
            }
            return false;
        }
        if (instance != null) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.cooldown = this.userConfig.transientCooldown;
        this.chakraFocus = new ChakraFocus(user);
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.durationBar != null && this.durationBar.update() == Updatable.UpdateResult.REMOVE) {
            this.durationBar.onRemove();
            this.durationBar = null;
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.chakraFocus != null && this.chakraFocus.update() == Updatable.UpdateResult.REMOVE) {
            this.tryActivate();
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private void onClick() {
        if (this.chakraFocus != null) {
            ChakraFocus.FocusResult result = this.chakraFocus.tryFocus();
            if (result == ChakraFocus.FocusResult.FAIL) {
                this.user.playSound(Sound.ENTITY_VILLAGER_NO.asEffect(1.0f, 0.9f).sound());
                this.removalPolicy = (u, d) -> true;
            } else if (result == ChakraFocus.FocusResult.SUCCESS) {
                this.tryActivate();
            }
        }
    }

    private void tryActivate() {
        long duration;
        boolean fullAvatarState;
        if (this.chakraFocus == null) {
            return;
        }
        Set<Chakra> openedChakras = this.chakraFocus.getOpenChakras();
        this.chakraFocus.onRemove();
        this.chakraFocus = null;
        ElementSet elementsWithOpenChakras = ElementSet.copyOf(openedChakras.stream().map(Chakra::element).filter(Objects::nonNull).toList());
        if (elementsWithOpenChakras.isEmpty()) {
            this.removalPolicy = (u, d) -> true;
            return;
        }
        boolean bl = fullAvatarState = openedChakras.size() == Chakra.VALUES.size();
        if (fullAvatarState) {
            this.cooldown = this.userConfig.cooldown;
            duration = this.userConfig.duration;
        } else {
            duration = this.userConfig.transientDuration;
        }
        int durationTicks = Platform.instance().toTicks(duration, TimeUnit.MILLISECONDS);
        int glowTicks = fullAvatarState ? durationTicks : 8;
        this.user.addPotion(PotionEffect.GLOWING.builder().duration(glowTicks).amplifier(0).build());
        this.removalPolicy = Policies.defaults();
        this.setupAvatarStateBar(elementsWithOpenChakras, fullAvatarState, durationTicks);
        this.resetCooldownsAndEffects(elementsWithOpenChakras, fullAvatarState);
        this.addModifiers(elementsWithOpenChakras);
    }

    private void setupAvatarStateBar(Set<Element> elements, boolean fullAvatarState, int durationTicks) {
        User user = this.user;
        if (user instanceof Player) {
            Player player = (Player)((Object)user);
            Component name = this.description().displayName();
            if (!fullAvatarState) {
                JoinConfiguration joiner = (JoinConfiguration)JoinConfiguration.builder().separator((ComponentLike)Component.text((String)", ")).prefix((ComponentLike)Component.text((String)"(")).suffix((ComponentLike)Component.text((String)")")).build();
                Component elementNames = Component.join((JoinConfiguration)joiner, elements.stream().map(Element::displayName).toList());
                name = name.append((Component)Component.space()).append(elementNames.color(ColorPalette.NEUTRAL));
            }
            BossBar bossBar = BossBar.bossBar((Component)name, (float)1.0f, (BossBar.Color)BossBar.Color.WHITE, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
            this.durationBar = BendingBar.of(bossBar, player, durationTicks);
        }
    }

    private void resetCooldownsAndEffects(Set<Element> elements, boolean fullAvatarState) {
        ActionLimiter.MANAGER.get(this.user.uuid()).ifPresent(Temporary::revert);
        if (fullAvatarState) {
            HashSet abilities = new HashSet();
            this.user.slots().forEach((desc, idx) -> {
                if (elements.containsAll(desc.elements())) {
                    abilities.add(desc);
                }
            });
            abilities.forEach(desc -> Cooldown.MANAGER.get(Cooldown.of(this.user, desc)).ifPresent(Temporary::revert));
        }
    }

    private void addModifiers(Set<Element> elements) {
        this.cleanupModifiers();
        if (this.avatarPolicy == null) {
            this.avatarPolicy = new AvatarModifyPolicy(this.user, elements);
            Sound.BLOCK_BEACON_ACTIVATE.asEffect(2.0f, 2.0f).play(this.user.world(), this.user.eyeLocation());
        }
        AVATAR_MODIFIERS.forEach((attribute, modifier) -> this.user.attributeModifiers().add(this.avatarPolicy, (Attribute)((Object)attribute), (Modifier)modifier));
    }

    private void cleanupModifiers() {
        if (this.avatarPolicy != null) {
            this.avatarPolicy.active().set(false);
            this.avatarPolicy = null;
            Sound.BLOCK_BEACON_DEACTIVATE.asEffect(2.0f, 1.5f).play(this.user.world(), this.user.eyeLocation());
        }
        this.user.attributeModifiers().remove(modifier -> modifier.policy().key().equals((Object)AVATAR_MODIFIER_KEY));
    }

    @Override
    public void onDestroy() {
        if (this.durationBar != null) {
            this.durationBar.onRemove();
        }
        if (this.chakraFocus != null) {
            this.chakraFocus.onRemove();
        }
        this.cleanupModifiers();
        this.user.removePotion(PotionEffect.GLOWING);
        this.user.addCooldown(this.description(), this.cooldown);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 120000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 60000L;
        @Modifiable(value=Attribute.COOLDOWN)
        private long transientCooldown = 30000L;
        @Modifiable(value=Attribute.DURATION)
        private long transientDuration = 3000L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "avatar", "avatarstate");
        }
    }

    private record AvatarModifyPolicy(Key key, User user, Set<Element> elementFilter, AtomicBoolean active) implements ModifyPolicy
    {
        private AvatarModifyPolicy(User user, Set<Element> elementFilter) {
            this(AVATAR_MODIFIER_KEY, user, elementFilter, new AtomicBoolean(true));
        }

        @Override
        public boolean shouldModify(AbilityDescription desc) {
            return this.active.get() && this.isValidAbility(desc) && !this.isPassive(desc);
        }

        private boolean isValidAbility(AbilityDescription desc) {
            Set<Element> abilityElements = desc.elements();
            return abilityElements.size() < Element.VALUES.size() && this.elementFilter.containsAll(abilityElements);
        }

        private boolean isPassive(AbilityDescription desc) {
            return desc.isActivatedBy(Activation.PASSIVE) && !desc.canBind();
        }
    }
}

