/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air.passive;

import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.entity.EntityUtil;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;

public class AirAgility
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;

    public AirAgility(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(Policies.FLYING).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description()) || !this.user.canBend(this.description())) {
            this.onDestroy();
            return Updatable.UpdateResult.CONTINUE;
        }
        EntityUtil.tryAddPotion(this.user, PotionEffect.JUMP_BOOST, 100, this.userConfig.jumpAmplifier - 1);
        EntityUtil.tryAddPotion(this.user, PotionEffect.SPEED, 100, this.userConfig.speedAmplifier - 1);
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public void onDestroy() {
        EntityUtil.tryRemovePotion(this.user, PotionEffect.JUMP_BOOST, 100, this.userConfig.jumpAmplifier - 1);
        EntityUtil.tryRemovePotion(this.user, PotionEffect.SPEED, 100, this.userConfig.speedAmplifier - 1);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.STRENGTH)
        private int speedAmplifier = 2;
        @Modifiable(value=Attribute.STRENGTH)
        private int jumpAmplifier = 3;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "passives", "airagility");
        }
    }
}

