/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;

public class Tornado
extends AbilityInstance {
    private static final DataKey<Mode> KEY = KeyUtil.data("tornado-mode", Mode.class);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Mode mode;
    private double yOffset = 0.0;
    private double currentAngle = 0.0;
    private long startTime;

    public Tornado(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(ExpireRemovalPolicy.of(this.userConfig.duration)).add(Policies.NOT_SNEAKING).add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).build();
        this.mode = user.store().get(KEY).orElse(Mode.PUSH);
        this.startTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        Vector3d base = this.user.rayTrace(this.userConfig.range).ignoreLiquids(false).blocks(this.user.world()).position();
        Block baseBlock = this.user.world().blockAt(base);
        if (MaterialUtil.isTransparent(baseBlock.offset(Direction.DOWN))) {
            return Updatable.UpdateResult.CONTINUE;
        }
        if (!this.user.canBuild(baseBlock)) {
            return Updatable.UpdateResult.REMOVE;
        }
        long time = System.currentTimeMillis();
        double factor = Math.min(1.0, (double)(time - this.startTime) / (double)this.userConfig.growthTime);
        double height = 2.0 + factor * (this.userConfig.height - 2.0);
        double radius = 2.0 + factor * (this.userConfig.radius - 2.0);
        double rBox = 0.6 * radius;
        AABB box = AABB.of(Vector3d.of(-rBox, 0.0, -rBox), Vector3d.of(rBox, height, rBox)).at(base);
        CollisionUtil.handle(this.user, box, entity -> {
            Vector3d velocity;
            double dy = entity.location().y() - base.y();
            double r = 0.5 + (radius - 0.5) * dy;
            Vector3d delta = (Vector3d)entity.center().subtract(base);
            double distSq = delta.x() * delta.x() + delta.z() * delta.z();
            if (distSq > r * r) {
                return false;
            }
            if (entity.uuid().equals(this.user.uuid())) {
                double velY = dy >= height * 0.95 ? 0.0 : (dy >= height * 0.85 ? 6.0 * (0.95 - dy / height) : 0.6);
                velocity = (Vector3d)((Vector3d)this.user.direction().withY(velY)).multiply(factor);
            } else if (this.mode == Mode.PULL) {
                velocity = (Vector3d)delta.add(0.0, 0.75 * height, 0.0).normalize().multiply(factor);
            } else {
                Vector3d normal = ((Vector3d)delta.withY(0.0)).normalize();
                Vector3d ortho = normal.cross(Vector3d.PLUS_J).normalize();
                velocity = (Vector3d)((Vector3d)ortho.add(normal)).normalize().add(0.0, 0.5, 0.0).multiply(factor);
            }
            entity.applyVelocity(this, velocity);
            return false;
        }, false, true);
        this.render(base, factor, height, radius);
        return Updatable.UpdateResult.CONTINUE;
    }

    private void render(Vector3d base, double factor, double height, double radius) {
        double amount = Math.clamp(factor * 30.0, 4.0, 30.0);
        this.yOffset += 0.1;
        if (this.yOffset >= 1.0) {
            this.yOffset = 0.0;
        }
        this.currentAngle += 4.5;
        if (this.currentAngle >= 360.0) {
            this.currentAngle = 0.0;
        }
        for (int i = 0; i < 3; ++i) {
            double offset = this.currentAngle + (double)(i * 2) * Math.PI / 3.0;
            for (double y = this.yOffset; y < height; y += height / amount) {
                double r = 0.5 + (radius - 0.5) * y / height;
                double x = r * Math.cos(y + offset);
                double z = r * Math.sin(y + offset);
                Vector3d loc = base.add(x, y, z);
                ParticleBuilder.air(loc).spawn(this.user.world());
                if (ThreadLocalRandom.current().nextInt(28) != 0) continue;
                SoundEffect.AIR.play(this.user.world(), loc);
            }
        }
    }

    @Override
    public void onDestroy() {
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    public static void switchMode(User user) {
        if (user.hasAbilitySelected("tornado") && user.store().canEdit(KEY)) {
            Mode mode = user.store().toggle(KEY, Mode.PUSH);
            user.sendActionBar((Component)Component.text((String)("Mode: " + mode.name()), (TextColor)ColorPalette.TEXT_COLOR));
            user.game().abilityManager(user.worldKey()).firstInstance(user, Tornado.class).ifPresent(t -> {
                t.mode = mode;
            });
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 4000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 8000L;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 8.0;
        @Modifiable(value=Attribute.HEIGHT)
        private double height = 12.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 16.0;
        private long growthTime = 3000L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "tornado");
        }
    }

    private static enum Mode {
        PUSH,
        PULL;

    }
}

