/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.RayUtil;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public class AirBurst
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<AirStream> streams = MultiUpdatable.empty();
    private boolean released;
    private long startTime;

    public AirBurst(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.ATTACK) {
            user.game().abilityManager(user.worldKey()).firstInstance(user, AirBurst.class).ifPresent(b -> b.release(Mode.CONE));
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.released = false;
        if (method == Activation.FALL) {
            if (user.propertyValue(EntityProperties.FALL_DISTANCE) < this.userConfig.fallThreshold || user.sneaking()) {
                return false;
            }
            this.release(Mode.FALL);
        }
        this.startTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.released) {
            boolean charged = this.isCharged();
            if (charged) {
                ParticleBuilder.air(this.user.mainHandSide()).spawn(this.user.world());
                if (!this.user.sneaking()) {
                    this.release(Mode.SPHERE);
                }
            } else if (!this.user.sneaking()) {
                return Updatable.UpdateResult.REMOVE;
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        return this.streams.update();
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(ParticleStream::collider).toList();
    }

    @Override
    public void onCollision(Collision collision) {
        Collider collider = collision.colliderSelf();
        this.streams.removeIf(stream -> stream.collider().equals(collider));
        if (collision.removeSelf() && !this.streams.isEmpty()) {
            collision.removeSelf(false);
        }
    }

    private boolean isCharged() {
        return System.currentTimeMillis() >= this.startTime + this.userConfig.chargeTime;
    }

    private void release(Mode mode) {
        if (this.released || !this.isCharged()) {
            return;
        }
        this.released = true;
        Collection<Ray> rays = switch (mode.ordinal()) {
            case 0 -> RayUtil.cone(this.user, this.userConfig.coneRange);
            case 2 -> RayUtil.fall(this.user, this.userConfig.sphereRange);
            default -> RayUtil.sphere(this.user, this.userConfig.sphereRange);
        };
        rays.forEach(r -> this.streams.add(new AirStream((Ray)r)));
        this.removalPolicy = Policies.defaults();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long chargeTime = 2500L;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 1.2;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 1.2;
        @Modifiable(value=Attribute.RANGE)
        private double sphereRange = 12.0;
        @Modifiable(value=Attribute.RANGE)
        private double coneRange = 16.0;
        private double fallThreshold = 14.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airburst");
        }
    }

    private static enum Mode {
        CONE,
        SPHERE,
        FALL;

    }

    private class AirStream
    extends ParticleStream {
        private long nextRenderTime;

        public AirStream(Ray ray) {
            super(AirBurst.this.user, ray, AirBurst.this.userConfig.speed, 1.3);
            this.canCollide = b -> b.isLiquid() || MaterialUtil.isFire(b);
            this.livingOnly = false;
        }

        @Override
        public void render(Vector3d location) {
            long time = System.currentTimeMillis();
            if (time >= this.nextRenderTime) {
                ParticleBuilder.air(location).offset(0.2).spawn(AirBurst.this.user.world());
                this.nextRenderTime = time + 75L;
            }
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(18) == 0) {
                SoundEffect.AIR_FAST.play(AirBurst.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            double factor = AirBurst.this.userConfig.knockback;
            BendingEffect.FIRE_TICK.reset(entity);
            if (factor == 0.0) {
                return false;
            }
            Vector3d push = this.ray.direction().normalize();
            push = (Vector3d)push.withY(Math.clamp(push.y(), -0.3, 0.3));
            factor *= 1.0 - this.distanceTravelled / (2.0 * this.maxRange);
            Vector3d velocity = entity.velocity();
            double strength = velocity.dot(push.normalize());
            if (strength > factor) {
                double f = velocity.normalize().dot(push.normalize());
                velocity = (Vector3d)((Vector3d)velocity.multiply(0.5)).add((Position)push.normalize().multiply(f));
            } else {
                velocity = strength + factor * 0.5 > factor ? (Vector3d)velocity.add((Position)push.multiply(factor - strength)) : (Vector3d)velocity.add((Position)push.multiply(factor * 0.5));
            }
            entity.applyVelocity(AirBurst.this, velocity);
            entity.setProperty(EntityProperties.FALL_DISTANCE, 0.0);
            return false;
        }

        @Override
        public boolean onBlockHit(Block block) {
            if (WorldUtil.tryExtinguishFire(AirBurst.this.user, block)) {
                return false;
            }
            WorldUtil.tryCoolLava(AirBurst.this.user, block);
            return true;
        }
    }
}

