/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.SimpleAbility;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;

public class AirBreath
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<AirStream> streams = MultiUpdatable.empty();

    public AirBreath(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, AirBreath.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).add(ExpireRemovalPolicy.of(this.userConfig.duration)).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.user.editProperty(EntityProperties.REMAINING_OXYGEN, air -> air - 5);
        Vector3d offset = Vector3d.of(0.0, -0.1, 0.0);
        Ray ray = Ray.of((Vector3d)this.user.eyeLocation().add(offset), (Vector3d)this.user.direction().multiply(this.userConfig.range));
        this.streams.add(new AirStream(ray));
        return this.streams.update();
    }

    @Override
    public void onDestroy() {
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(SimpleAbility::collider).toList();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 5000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 7.0;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 1000L;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 0.5;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airbreath");
        }
    }

    private class AirStream
    extends ParticleStream {
        private static final double ORIGINAL_COLLISION_RADIUS = 0.5;

        public AirStream(Ray ray) {
            super(AirBreath.this.user, ray, 1.0, 0.5);
            this.canCollide = b -> b.isLiquid() || MaterialUtil.isFire(b);
            this.livingOnly = false;
        }

        @Override
        public void render(Vector3d location) {
            double offset = 0.15 * this.distanceTravelled;
            this.collisionRadius = 0.5 + offset;
            Block block = AirBreath.this.user.world().blockAt(location);
            if (MaterialUtil.isWater(block)) {
                ParticleBuilder.bubble(block).spawn(AirBreath.this.user.world());
            } else {
                ParticleBuilder.air(location).count(FastMath.ceil(this.distanceTravelled)).offset(offset).spawn(AirBreath.this.user.world());
            }
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(4) == 0) {
                SoundEffect.AIR.play(AirBreath.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            entity.applyVelocity(AirBreath.this, (Vector3d)this.ray.direction().normalize().multiply(AirBreath.this.userConfig.knockback));
            BendingEffect.FIRE_TICK.reset(entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.editProperty(EntityProperties.REMAINING_OXYGEN, air -> air + 1);
            }
            return false;
        }

        @Override
        public boolean onBlockHit(Block block) {
            if (WorldUtil.tryExtinguishFire(AirBreath.this.user, block)) {
                return false;
            }
            WorldUtil.tryCoolLava(AirBreath.this.user, block);
            if (!MaterialUtil.isTransparentOrWater(block) && AirBreath.this.user.pitch() > 30.0f) {
                AirBreath.this.user.applyVelocity(AirBreath.this, (Vector3d)AirBreath.this.user.direction().multiply(-AirBreath.this.userConfig.knockback));
                BendingEffect.FIRE_TICK.reset(AirBreath.this.user);
            }
            return !MaterialUtil.isWater(block);
        }
    }
}

