/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.OutOfRangeRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;

public class AirBlast
extends AbilityInstance {
    private static final DataKey<Mode> KEY = KeyUtil.data("airblast-mode", Mode.class);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private AirStream stream;
    private Vector3d origin;
    private boolean launched;
    private boolean selectedOrigin;

    public AirBlast(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        if (Policies.UNDER_WATER.test(user, this.description()) || Policies.UNDER_LAVA.test(user, this.description())) {
            return false;
        }
        this.removalPolicy = Policies.builder().add(OutOfRangeRemovalPolicy.of(this.userConfig.selectRange * 2.0, () -> this.origin)).add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).build();
        for (AirBlast blast : user.game().abilityManager(user.worldKey()).userInstances(user, AirBlast.class).toList()) {
            if (blast.launched) continue;
            if (method == Activation.SNEAK_RELEASE) {
                if (!blast.selectOrigin()) {
                    user.game().abilityManager(user.worldKey()).destroyInstance(blast);
                }
            } else {
                blast.launch();
            }
            return false;
        }
        if (method == Activation.SNEAK_RELEASE) {
            return this.selectOrigin();
        }
        this.origin = user.eyeLocation();
        this.launch();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.launched) {
            if (!this.description().equals(this.user.selectedAbility())) {
                return Updatable.UpdateResult.REMOVE;
            }
            ParticleBuilder.air(this.origin).count(4).offset(0.5).spawn(this.user.world());
            return Updatable.UpdateResult.CONTINUE;
        }
        return this.stream.update();
    }

    private boolean selectOrigin() {
        Vector3d offset = (Vector3d)this.user.direction().multiply(0.5);
        this.origin = (Vector3d)this.user.rayTrace(this.userConfig.selectRange).ignoreLiquids(false).cast(this.user.world()).position().subtract(offset);
        this.selectedOrigin = true;
        return this.user.canBuild(this.origin);
    }

    private void launch() {
        this.launched = true;
        Vector3d target = this.user.rayTrace(this.userConfig.range).cast(this.user.world()).entityCenterOrPosition();
        if (this.user.store().get(KEY).orElse(Mode.PUSH) == Mode.PULL) {
            Vector3d temp = this.origin;
            this.origin = target;
            target = temp;
        }
        Vector3d direction = ((Vector3d)target.subtract(this.origin)).normalize();
        this.removalPolicy = Policies.defaults();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        this.stream = new AirStream(Ray.of(this.origin, (Vector3d)direction.multiply(this.userConfig.range)));
    }

    @Override
    public Collection<Collider> colliders() {
        return this.stream == null ? List.of() : List.of(this.stream.collider());
    }

    public static void switchMode(User user) {
        if (user.hasAbilitySelected("airblast") && user.store().canEdit(KEY)) {
            Mode mode = user.store().toggle(KEY, Mode.PUSH);
            user.sendActionBar((Component)Component.text((String)("Mode: " + mode.name()), (TextColor)ColorPalette.TEXT_COLOR));
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 1250L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 20.0;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 1.2;
        @Modifiable(value=Attribute.STRENGTH)
        private double powerSelf = 2.1;
        @Modifiable(value=Attribute.STRENGTH)
        private double powerOther = 2.1;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 8.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airblast");
        }
    }

    private class AirStream
    extends ParticleStream {
        public AirStream(Ray ray) {
            super(AirBlast.this.user, ray, AirBlast.this.userConfig.speed, 1.0);
            this.canCollide = b -> b.isLiquid() || MaterialUtil.isFire(b);
            this.livingOnly = false;
            this.selfCollision = AirBlast.this.selectedOrigin;
        }

        @Override
        public void render(Vector3d location) {
            ParticleBuilder.air(location).count(6).offset(0.275).spawn(AirBlast.this.user.world());
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(4) == 0) {
                SoundEffect.AIR_FAST.play(AirBlast.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            Vector3d velocity;
            double strength;
            boolean isUser = entity.uuid().equals(AirBlast.this.user.uuid());
            double factor = isUser ? AirBlast.this.userConfig.powerSelf : AirBlast.this.userConfig.powerOther;
            BendingEffect.FIRE_TICK.reset(entity);
            if (factor == 0.0) {
                return false;
            }
            Vector3d push = this.ray.direction().normalize();
            if (!isUser) {
                push = (Vector3d)push.withY(Math.clamp(push.y(), -0.3, 0.3));
            }
            factor *= 1.0 - this.distanceTravelled / (2.0 * this.maxRange);
            if (isUser && AirBlast.this.user.isOnGround()) {
                factor *= 0.5;
            }
            if ((strength = (velocity = entity.velocity()).dot(push.normalize())) > factor) {
                double f = velocity.normalize().dot(push.normalize());
                velocity = (Vector3d)((Vector3d)velocity.multiply(0.5)).add((Position)push.normalize().multiply(f));
            } else {
                velocity = strength + factor * 0.5 > factor ? (Vector3d)velocity.add((Position)push.multiply(factor - strength)) : (Vector3d)velocity.add((Position)push.multiply(factor * 0.5));
            }
            entity.applyVelocity(AirBlast.this, velocity);
            entity.setProperty(EntityProperties.FALL_DISTANCE, 0.0);
            return false;
        }

        @Override
        public boolean onBlockHit(Block block) {
            if (WorldUtil.tryExtinguishFire(AirBlast.this.user, block)) {
                return false;
            }
            WorldUtil.tryCoolLava(AirBlast.this.user, block);
            return true;
        }
    }

    private static enum Mode {
        PUSH,
        PULL;

    }
}

