/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.AbstractWheel;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.OutOfRangeRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.common.ability.air.sequence.AirWheel;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Rotation;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class AirBlade
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Vector3d origin;
    private Vector3d direction;
    private Blade blade;
    private boolean charging;
    private double factor = 1.0;
    private long startTime;
    private double chargingPoint;

    public AirBlade(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, AirBlade.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.charging = true;
        this.direction = ((Vector3d)user.direction().withY(0.0)).normalize();
        double maxRadius = this.userConfig.radius * this.userConfig.chargeFactor * 0.5;
        this.origin = ((Vector3d)user.location().add(this.direction)).add(0.0, maxRadius, 0.0);
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(OutOfRangeRemovalPolicy.of(this.userConfig.prepareRange, () -> this.origin)).add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).build();
        this.startTime = System.currentTimeMillis();
        AirWheel wheel = user.game().abilityManager(user.worldKey()).firstInstance(user, AirWheel.class).orElse(null);
        if (wheel != null) {
            this.origin = wheel.center();
            this.factor = this.userConfig.chargeFactor;
            this.charging = false;
            this.blade = new Blade(Ray.of(this.origin, this.direction), this.userConfig.speed * this.factor * 0.5);
            this.removalPolicy = Policies.builder().add(OutOfRangeRemovalPolicy.of(this.userConfig.range * this.factor, this.origin, () -> this.blade.location())).build();
            user.addCooldown(this.description(), this.userConfig.cooldown);
            user.game().abilityManager(user.worldKey()).destroyInstance(wheel);
        }
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.charging) {
            if (this.user.world().blockAt(this.origin).type().isLiquid()) {
                return Updatable.UpdateResult.REMOVE;
            }
            long time = System.currentTimeMillis();
            if (this.user.sneaking() && time > this.startTime + 100L) {
                double timeFactor = Math.min(0.9, (double)(time - this.startTime) / (double)this.userConfig.maxChargeTime);
                double r = this.userConfig.radius * this.userConfig.chargeFactor * timeFactor * 0.5;
                int amount = FastMath.ceil(r * 10.0);
                Rotation rotation = this.createNextRotation(Vector3d.PLUS_J.cross(this.direction), amount);
                VectorUtil.rotate((Vector3d)this.direction.multiply(r), rotation, amount).forEach(v -> ParticleBuilder.air(this.origin.add((Position)v)).spawn(this.user.world()));
                double[] offset = this.direction.toArray();
                for (double d = 0.1; d < r; d += 0.25) {
                    rotation.applyTo(offset, offset);
                    ParticleBuilder.air(this.origin.add((Position)Vector3d.from(offset).multiply(d))).spawn(this.user.world());
                }
                if (ThreadLocalRandom.current().nextInt(8) == 0) {
                    SoundEffect.AIR.play(this.user.world(), this.origin);
                }
            } else if (!this.user.sneaking()) {
                this.launch();
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        return this.blade.update();
    }

    private Rotation createNextRotation(Vector3d rotateAxis, int amount) {
        this.chargingPoint += 0.08726646259971647;
        return Rotation.from(rotateAxis, this.chargingPoint).applyTo(Rotation.from(rotateAxis, Math.PI * 2 / (double)amount));
    }

    private void launch() {
        long deltaTime = System.currentTimeMillis() - this.startTime;
        this.factor = 1.0;
        if (deltaTime >= this.userConfig.maxChargeTime) {
            this.factor = this.userConfig.chargeFactor;
        } else if ((double)deltaTime > 0.3 * (double)this.userConfig.maxChargeTime) {
            double deltaFactor = (this.userConfig.chargeFactor - this.factor) * (double)deltaTime / (double)this.userConfig.maxChargeTime;
            this.factor += deltaFactor;
        }
        this.charging = false;
        this.blade = new Blade(Ray.of(this.origin, this.direction));
        this.removalPolicy = Policies.builder().add(OutOfRangeRemovalPolicy.of(this.userConfig.range * this.factor, this.origin, () -> this.blade.location())).build();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    @Override
    public Collection<Collider> colliders() {
        return this.blade == null ? List.of() : List.of(this.blade.collider());
    }

    @Override
    public void onCollision(Collision collision) {
        Ability collidedAbility = collision.collidedAbility();
        if (collidedAbility instanceof AirBlade) {
            AirBlade other = (AirBlade)collidedAbility;
            if (this.factor - other.factor > 0.1) {
                collision.removeSelf(false);
            }
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 4000L;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 1.2;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 1.5;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 0.8;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockup = 0.15;
        @Modifiable(value=Attribute.RANGE)
        private double range = 12.0;
        @Modifiable(value=Attribute.RANGE)
        private double prepareRange = 8.0;
        @Comment(value="How many blocks the blade advances every tick")
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.8;
        @Comment(value="How many milliseconds it takes to fully charge")
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long maxChargeTime = 2000L;
        @Comment(value="How much the damage and range are multiplied by at full charge. Radius and speed are only affected by half that amount")
        @Modifiable(value=Attribute.STRENGTH)
        private double chargeFactor = 3.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airblade");
        }
    }

    private class Blade
    extends AbstractWheel {
        public Blade(Ray ray) {
            super(AirBlade.this.user, ray, AirBlade.this.userConfig.radius * AirBlade.this.factor * 0.5, AirBlade.this.userConfig.speed * AirBlade.this.factor * 0.5);
        }

        public Blade(Ray ray, double speed) {
            super(AirBlade.this.user, ray, 1.6, speed);
        }

        @Override
        public void render(Vector3d location) {
            int amount = FastMath.ceil(22.0 * this.radius);
            Rotation rotation = AirBlade.this.createNextRotation(Vector3d.PLUS_J.cross(this.ray.direction()), amount);
            VectorUtil.rotate((Vector3d)this.ray.direction().multiply(this.radius), rotation, amount).forEach(v -> ParticleBuilder.air(location.add((Position)v)).spawn(AirBlade.this.user.world()));
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(8) == 0) {
                SoundEffect.AIR.play(AirBlade.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            entity.damage(AirBlade.this.userConfig.damage * AirBlade.this.factor, AirBlade.this.user, AirBlade.this.description());
            Vector3d velocity = (Vector3d)((Vector3d)AirBlade.this.direction.withY(AirBlade.this.userConfig.knockup)).normalize().multiply(AirBlade.this.userConfig.knockback);
            entity.applyVelocity(AirBlade.this, velocity);
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            WorldUtil.tryExtinguishFire(AirBlade.this.user, block);
            return true;
        }
    }
}

