/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.moros.bending.api.addon.Addon;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.util.Tasker;
import me.moros.bending.common.Bending;
import me.moros.bending.common.ability.AbilityInitializer;
import me.moros.bending.common.config.BendingPropertiesImpl;
import me.moros.bending.common.config.ConfigManager;
import me.moros.bending.common.game.GameImpl;
import me.moros.bending.common.hook.PresetLimits;
import me.moros.bending.common.loader.AddonLoader;
import me.moros.bending.common.locale.TranslationManager;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.util.GameProviderUtil;
import me.moros.bending.common.util.ReflectionUtil;
import me.moros.tasker.executor.SyncExecutor;
import org.spongepowered.configurate.reference.WatchServiceListener;

public abstract class AbstractBending<T>
implements Bending {
    protected final T parent;
    private final Path path;
    private final Logger logger;
    private final WatchServiceListener listener;
    private final ConfigManager configManager;
    private final TranslationManager translationManager;
    private final Map<String, Supplier<Addon>> addonProviders;
    private final AddonLoader addonLoader;
    protected Game game;

    protected AbstractBending(T parent, Path dir, Logger logger) {
        this.parent = parent;
        this.path = dir;
        this.logger = logger;
        try {
            this.listener = WatchServiceListener.create();
            this.configManager = new ConfigManager(logger, dir, this.listener);
            this.translationManager = new TranslationManager(logger, dir, this.listener);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.addonProviders = new ConcurrentHashMap<String, Supplier<Addon>>();
        this.addonLoader = AddonLoader.create(this.logger(), this.path, this.getClass().getClassLoader());
        this.configManager.subscribe(new BendingPropertiesImpl(), this::injectProperties);
        new AbilityInitializer().init();
    }

    protected void injectTasker(SyncExecutor syncExecutor) {
        ReflectionUtil.injectStatic(Tasker.class, syncExecutor);
    }

    private void injectProperties(BendingProperties properties) {
        ReflectionUtil.injectStatic(BendingProperties.Holder.class, properties);
    }

    protected void registerNamedAddon(String name, Supplier<Addon> provider) {
        this.addonProviders.putIfAbsent(name, provider);
    }

    protected void load() {
        this.registerNamedAddon("preset-limits", PresetLimits::defaultLimits);
        this.addonLoader.loadAll(this.addonProviders.values());
        this.translationManager.refresh();
        this.game = new GameImpl(this);
        GameProviderUtil.registerProvider(this.game);
        this.addonLoader.enableAll(this.game);
    }

    @Override
    public void reload() {
        if (this.game != null) {
            this.game.reload();
        }
    }

    protected void softDisable() {
        if (this.game != null) {
            this.addonLoader.unloadAll();
            this.game.cleanup();
            this.game.storage().close();
            Tasker.sync().clear();
            GameProviderUtil.unregisterProvider();
            this.game = null;
        }
    }

    protected void disable() {
        if (this.game != null) {
            this.addonLoader.unloadAll();
            this.game.cleanup();
            this.game.eventBus().shutdown();
            this.configManager().close();
            try {
                this.listener.close();
            }
            catch (IOException e) {
                this.logger.warn(e.getMessage(), e);
            }
            Tasker.sync().shutdown();
            Tasker.async().shutdown();
            this.game.storage().close();
            GameProviderUtil.unregisterProvider();
            this.game = null;
        }
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public ConfigManager configManager() {
        return this.configManager;
    }

    @Override
    public TranslationManager translationManager() {
        return this.translationManager;
    }
}

