/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.qte;

import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.Updatable;
import me.moros.math.FastMath;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;

public abstract class QuickTimeEvent
implements Updatable {
    private static final int VALID_TICK_RANGE = 7;
    protected final Audience audience;
    protected final Component title;
    protected final BossBar bar;
    protected final int duration;
    protected final int targetTick;
    private State state;
    private int ticks;

    protected QuickTimeEvent(Audience audience, Component title, int duration) {
        this.audience = audience;
        this.title = title;
        this.bar = BossBar.bossBar((Component)this.title, (float)0.0f, (BossBar.Color)BossBar.Color.YELLOW, (BossBar.Overlay)BossBar.Overlay.NOTCHED_10);
        this.targetTick = FastMath.round((double)duration * 0.1 * (double)ThreadLocalRandom.current().nextInt(1, 9));
        this.duration = duration;
        this.state = State.PENDING_ATTEMPT;
        this.ticks = 0;
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.state != State.PENDING_ATTEMPT || this.ticks > this.duration) {
            this.onRemove();
            return Updatable.UpdateResult.REMOVE;
        }
        float factor = Math.clamp((float)(this.duration - this.ticks) / (float)this.duration, 0.0f, 1.0f);
        this.bar.name(this.formatTitle()).progress(factor);
        if (this.ticks++ == 0) {
            this.audience.showBossBar(this.bar);
        }
        if (this.ticks == this.targetTick) {
            this.notifyTick();
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private Component formatTitle() {
        return this.title.decoration(TextDecoration.UNDERLINED, this.isFocused());
    }

    public boolean isFocused() {
        return this.ticks >= this.targetTick && this.ticks <= this.targetTick + 7;
    }

    public void attempt() {
        if (this.state != State.PENDING_ATTEMPT) {
            return;
        }
        this.state = this.isFocused() ? State.SUCCESS : State.FAILURE;
    }

    protected abstract void onSuccess();

    protected abstract void onFailure();

    protected void notifyTick() {
    }

    public void onRemove() {
        if (this.state == State.HANDLED) {
            return;
        }
        this.audience.hideBossBar(this.bar);
        switch (this.state.ordinal()) {
            case 0: 
            case 2: {
                this.onFailure();
                break;
            }
            case 1: {
                this.onSuccess();
            }
        }
        this.state = State.HANDLED;
    }

    private static enum State {
        PENDING_ATTEMPT,
        SUCCESS,
        FAILURE,
        HANDLED;

    }
}

