/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.material;

import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.material.MaterialUtil;

public final class WaterMaterials {
    public static final BlockTag PLANT_BENDABLE = BlockTag.reference(KeyUtil.simple("plant_sources"));
    public static final BlockTag ICE_BENDABLE = BlockTag.reference(KeyUtil.simple("ice_sources"));
    public static final BlockTag SNOW_BENDABLE = BlockTag.reference(KeyUtil.simple("snow_sources"));
    public static final BlockTag FULL_SOURCES = BlockTag.reference(KeyUtil.simple("full_water_sources"));
    private static final BlockTag ALL = BlockTag.reference(KeyUtil.simple("all_water_sources"));

    public static void init() {
        BlockTag.builder(PLANT_BENDABLE.key()).add(BlockTag.reference(KeyUtil.simple("extra_plant_sources"))).add(BlockTag.FLOWERS).add(BlockTag.SAPLINGS).add(BlockTag.CROPS).add(BlockTag.LEAVES).add(BlockType.CACTUS, new BlockType[]{BlockType.MELON, BlockType.VINE, BlockType.CARVED_PUMPKIN, BlockType.JACK_O_LANTERN, BlockType.PUMPKIN, BlockType.BROWN_MUSHROOM, BlockType.RED_MUSHROOM, BlockType.BROWN_MUSHROOM_BLOCK, BlockType.RED_MUSHROOM_BLOCK, BlockType.MUSHROOM_STEM}).buildAndRegister();
        BlockTag.builder(ICE_BENDABLE.key()).add(BlockTag.reference(KeyUtil.simple("extra_ice_sources"))).add(BlockTag.ICE).buildAndRegister();
        BlockTag.builder(SNOW_BENDABLE.key()).add(BlockTag.reference(KeyUtil.simple("extra_snow_sources"))).add(BlockType.SNOW, new BlockType[]{BlockType.SNOW_BLOCK}).buildAndRegister();
        BlockTag.builder(FULL_SOURCES.key()).add(BlockTag.reference(KeyUtil.simple("extra_full_water_sources"))).add(ICE_BENDABLE).add(BlockTag.LEAVES).add(BlockType.WATER, new BlockType[]{BlockType.CACTUS, BlockType.MELON, BlockType.SNOW_BLOCK, BlockType.CARVED_PUMPKIN, BlockType.JACK_O_LANTERN, BlockType.PUMPKIN, BlockType.BROWN_MUSHROOM_BLOCK, BlockType.RED_MUSHROOM_BLOCK, BlockType.MUSHROOM_STEM}).buildAndRegister();
        BlockTag.builder(ALL.key()).add(BlockTag.reference(KeyUtil.simple("extra_water_sources"))).add(PLANT_BENDABLE).add(ICE_BENDABLE).add(SNOW_BENDABLE).add(BlockType.WATER).buildAndRegister();
    }

    private WaterMaterials() {
    }

    public static boolean isWaterBendable(Block block) {
        return MaterialUtil.isWater(block) || ALL.isTagged(block);
    }

    public static boolean isWaterNotPlant(Block block) {
        return WaterMaterials.isWaterBendable(block) && !PLANT_BENDABLE.isTagged(block);
    }

    public static boolean isIceBendable(Block block) {
        return ICE_BENDABLE.isTagged(block);
    }

    public static boolean isSnowBendable(Block block) {
        return SNOW_BENDABLE.isTagged(block);
    }

    public static boolean isWaterOrIceBendable(Block block) {
        return MaterialUtil.isWater(block) || ICE_BENDABLE.isTagged(block);
    }

    public static boolean isPlantBendable(Block block) {
        return PLANT_BENDABLE.isTagged(block);
    }

    public static boolean isFullWaterSource(Block block) {
        return FULL_SOURCES.isTagged(block) || MaterialUtil.isWaterPlant(block);
    }
}

