/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.functional;

import java.util.HashSet;
import java.util.Set;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.util.functional.RemovalPolicy;
import net.kyori.adventure.util.TriState;

public final class Policies {
    public static final RemovalPolicy DEAD = (u, d) -> u.propertyValue(EntityProperties.DEAD);
    public static final RemovalPolicy INVALID = (u, d) -> !u.valid();
    public static final RemovalPolicy SNEAKING = (u, d) -> u.sneaking();
    public static final RemovalPolicy NOT_SNEAKING = (u, d) -> !u.sneaking();
    public static final RemovalPolicy FLYING = (u, d) -> u.checkProperty(EntityProperties.FLYING) == TriState.TRUE;
    public static final RemovalPolicy UNDER_WATER = (u, d) -> u.underWater();
    public static final RemovalPolicy PARTIALLY_UNDER_WATER = (u, d) -> u.inWater();
    public static final RemovalPolicy UNDER_LAVA = (u, d) -> u.underLava();
    public static final RemovalPolicy PARTIALLY_UNDER_LAVA = (u, d) -> u.inLava();
    private static final RemovalPolicy DEFAULT = Policies.builder().build();

    private Policies() {
    }

    public static RemovalPolicy defaults() {
        return DEFAULT;
    }

    public static Builder builder() {
        return new Builder().add(DEAD).add(INVALID);
    }

    public static final class Builder {
        private final Set<RemovalPolicy> policies = new HashSet<RemovalPolicy>();

        private Builder() {
        }

        public Builder add(RemovalPolicy policy) {
            this.policies.add(policy);
            return this;
        }

        public Builder remove(RemovalPolicy policy) {
            this.policies.remove(policy);
            return this;
        }

        public RemovalPolicy build() {
            return this.policies.stream().reduce((u, d) -> false, RemovalPolicy::or);
        }
    }
}

