/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.functional;

import java.util.function.BiPredicate;
import java.util.stream.Stream;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.user.User;

public final class BendingConditions {
    public static final BiPredicate<User, AbilityDescription> CAN_BEND = (u, d) -> u.canBend();
    public static final BiPredicate<User, AbilityDescription> COOLDOWN = (u, d) -> d.bypassCooldown() || !u.onCooldown((AbilityDescription)d);
    public static final BiPredicate<User, AbilityDescription> ELEMENT = (u, d) -> u.hasElements(d.elements());
    public static final BiPredicate<User, AbilityDescription> GAMEMODE = (u, d) -> !u.isSpectator();
    public static final BiPredicate<User, AbilityDescription> PERMISSION = (u, d) -> u.hasPermission((AbilityDescription)d);
    public static final BiPredicate<User, AbilityDescription> WORLD = (u, d) -> u.game().worldManager().isEnabled(u.worldKey());
    private static final BiPredicate<User, AbilityDescription> ALL = Stream.of(CAN_BEND, ELEMENT, GAMEMODE, COOLDOWN, WORLD, PERMISSION).reduce((u, d) -> true, BiPredicate::and);

    private BendingConditions() {
    }

    public static BiPredicate<User, AbilityDescription> all() {
        return ALL;
    }
}

