/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.collect;

import java.util.Set;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.util.collect.ImmutableElementSet;
import me.moros.bending.api.util.collect.MutableElementSet;

public sealed interface ElementSet
extends Set<Element>
permits MutableElementSet, ImmutableElementSet {
    public int elements();

    public boolean set(Set<Element> var1);

    public static ElementSet mutable() {
        return new MutableElementSet();
    }

    public static ElementSet of() {
        return ImmutableElementSet.EMPTY;
    }

    public static ElementSet of(Element element) {
        return ImmutableElementSet.from(1 << element.ordinal());
    }

    public static ElementSet copyOf(Iterable<Element> c) {
        int value;
        if (c instanceof ImmutableElementSet) {
            ImmutableElementSet other = (ImmutableElementSet)c;
            return other;
        }
        if (c instanceof ElementSet) {
            ElementSet other = (ElementSet)c;
            value = other.elements();
        } else {
            value = 0;
            for (Element element : c) {
                value |= 1 << element.ordinal();
            }
        }
        return ImmutableElementSet.from(value);
    }
}

