/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util;

import java.util.function.Function;
import me.moros.bending.api.util.data.DataKey;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KeyUtil {
    public static final String BENDING_NAMESPACE = "bending";
    public static final Function<String, @Nullable Key> BENDING_KEY_MAPPER = KeyUtil.stringToKey("bending");
    public static final Function<String, @Nullable Key> VANILLA_KEY_MAPPER = KeyUtil.stringToKey("minecraft");

    private KeyUtil() {
    }

    public static Function<String, @Nullable Key> stringToKey(String namespace) {
        if (!Key.parseableNamespace((String)namespace)) {
            throw new IllegalArgumentException("Invalid namespace %s.".formatted(namespace));
        }
        return input -> KeyUtil.fromString(input, namespace);
    }

    public static Key vanilla(String value) {
        return Key.key((String)"minecraft", (String)value);
    }

    public static Key simple(String value) {
        return Key.key((String)BENDING_NAMESPACE, (String)value);
    }

    public static <V> DataKey<V> data(String value, Class<V> type) {
        return DataKey.wrap(Key.key((String)BENDING_NAMESPACE, (String)value), type);
    }

    public static String concat(Key key) {
        return key.namespace() + "." + key.value();
    }

    private static @Nullable Key fromString(String string, String defNamespace) {
        String value;
        int index = string.indexOf(58);
        String namespace = index >= 1 ? string.substring(0, index) : defNamespace;
        String string2 = value = index >= 0 ? string.substring(index + 1) : string;
        if ((namespace.equals(defNamespace) || Key.parseableNamespace((String)namespace)) && Key.parseableValue((String)value)) {
            return Key.key((String)namespace, (String)value);
        }
        return null;
    }
}

