/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ExpiringSet<E> {
    private final Cache<E, Boolean> cache;

    public ExpiringSet(long duration) {
        this(duration, TimeUnit.MILLISECONDS);
    }

    public ExpiringSet(long duration, TimeUnit unit) {
        this.cache = Caffeine.newBuilder().expireAfterWrite(duration, unit).build();
    }

    public void forceAdd(E item) {
        this.cache.put(item, (Object)false);
    }

    public boolean add(E item) {
        if (this.contains(item)) {
            return false;
        }
        this.forceAdd(item);
        return true;
    }

    public boolean contains(E item) {
        return this.cache.getIfPresent(item) != null;
    }

    public Set<E> snapshot() {
        return Set.copyOf(this.cache.asMap().keySet());
    }
}

