/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BendingExplosion {
    private final double size;
    private final double damage;
    private final double selfKnockbackFactor;
    private final double halfSize;
    private final double sizeFactor;
    private final int fireTicks;
    private final boolean livingOnly;
    private final boolean particles;
    private final boolean breakBlocks;
    private final boolean placeFire;
    private final Collider ignoreInside;
    private final SoundEffect sound;

    private BendingExplosion(Builder builder) {
        this.size = builder.size;
        this.damage = builder.damage;
        this.selfKnockbackFactor = builder.selfKnockbackFactor;
        this.fireTicks = builder.fireTicks;
        this.livingOnly = builder.livingOnly;
        this.particles = builder.particles;
        this.breakBlocks = builder.breakBlocks;
        this.placeFire = builder.placeFire;
        this.ignoreInside = builder.ignoreInside;
        this.sound = builder.sound;
        this.halfSize = this.size / 2.0;
        this.sizeFactor = Math.sqrt(this.size);
    }

    private void playParticles(World world, Vector3d center) {
        if (this.size <= 1.5) {
            Particle.POOF.builder(center).count(FastMath.ceil(10.0 * this.size)).offset(0.75).spawn(world);
        } else if (this.size <= 3.0) {
            Particle.EXPLOSION.builder(center).count(FastMath.ceil(3.0 * this.size)).offset(0.5).spawn(world);
        } else if (this.size <= 5.0) {
            Particle.EXPLOSION_EMITTER.builder(center).spawn(world);
        } else {
            Particle.EXPLOSION_EMITTER.builder(center).count(FastMath.ceil(this.size / 5.0)).spawn(world);
        }
    }

    public boolean explode(Ability source, Vector3d center) {
        ArrayList<Block> blocks;
        User user = source.user();
        World world = user.world();
        AbilityDescription desc = source.description();
        Predicate<Block> predicate = b -> !MaterialUtil.isAir(b) && !MaterialUtil.isUnbreakable(b) && !b.type().isLiquid();
        List<Block> list = blocks = this.breakBlocks ? world.nearbyBlocks(center, this.size, predicate) : new ArrayList<Block>();
        if (user.game().eventBus().postExplosionEvent(user, desc, center, blocks).cancelled()) {
            return false;
        }
        if (this.particles) {
            this.playParticles(world, center);
        }
        if (this.sound != null) {
            this.sound.play(world, center);
        }
        if (this.breakBlocks && !world.blockAt(center).type().isLiquid()) {
            List<Block> filteredBlocks = blocks.stream().filter(predicate).filter(user::canBuild).toList();
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (Block block : filteredBlocks) {
                TempBlock.air().fixWater(false).duration(BendingProperties.instance().explosionRevertTime(1000L)).build(block);
            }
            if (this.placeFire) {
                for (Block block : filteredBlocks) {
                    if (!MaterialUtil.isIgnitable(block) || rand.nextInt(3) != 0) continue;
                    TempBlock.fire().duration(BendingProperties.instance().fireRevertTime(1000L)).build(block);
                }
            }
        }
        return CollisionUtil.handle(user, Sphere.of(center, this.size), entity -> {
            double distanceFactor;
            Vector3d entityCenter = entity.center();
            double distance = center.distance(entityCenter);
            double d = distanceFactor = distance <= this.halfSize ? 1.0 : 1.0 - (distance - this.halfSize) / this.size;
            if (this.ignoreInside != null && this.ignoreInside.contains(entityCenter)) {
                distanceFactor *= 0.75;
            } else {
                BendingEffect.FIRE_TICK.apply(user, entity, this.fireTicks);
                entity.damage(this.damage * distanceFactor, user, desc);
            }
            double knockback = BendingProperties.instance().explosionKnockback(this.sizeFactor * distanceFactor);
            if (entity.uuid().equals(user.uuid())) {
                knockback *= this.selfKnockbackFactor;
            }
            Vector3d dir = (Vector3d)((Vector3d)entityCenter.subtract(center)).normalize().multiply(knockback);
            entity.applyVelocity(source, dir);
            return true;
        }, this.livingOnly, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private double size = 2.0;
        private double damage = 4.0;
        private double selfKnockbackFactor = 0.5;
        private int fireTicks = 40;
        private boolean livingOnly = true;
        private boolean particles = true;
        private boolean breakBlocks = false;
        private boolean placeFire = false;
        private Collider ignoreInside = null;
        private SoundEffect sound = null;

        private Builder() {
        }

        public Builder size(double size) {
            this.size = Math.abs(size);
            return this;
        }

        public Builder damage(double damage) {
            this.damage = Math.abs(damage);
            return this;
        }

        public Builder selfKnockbackFactor(double selfKnockbackFactor) {
            this.selfKnockbackFactor = Math.abs(selfKnockbackFactor);
            return this;
        }

        public Builder fireTicks(int fireTicks) {
            this.fireTicks = Math.abs(fireTicks);
            return this;
        }

        public Builder livingOnly(boolean livingOnly) {
            this.livingOnly = livingOnly;
            return this;
        }

        public Builder particles(boolean particles) {
            this.particles = particles;
            return this;
        }

        public Builder breakBlocks(boolean breakBlocks) {
            this.breakBlocks = breakBlocks;
            return this;
        }

        public Builder placeFire(boolean placeFire) {
            this.placeFire = placeFire;
            return this;
        }

        public Builder ignoreInsideCollider(@Nullable Collider ignoreInside) {
            this.ignoreInside = ignoreInside;
            return this;
        }

        public Builder sound(@Nullable SoundEffect sound) {
            this.sound = sound;
            return this;
        }

        public Builder sound(float volume, float pitch) {
            this.sound = SoundEffect.EXPLOSION.with(volume, pitch);
            return this;
        }

        public BendingExplosion build() {
            if (this.size <= 0.0) {
                this.size = 2.0;
            }
            return new BendingExplosion(this);
        }

        public boolean buildAndExplode(Ability source, Vector3d center) {
            return this.build().explode(source, center);
        }
    }
}

