/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.user;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.gui.Board;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.entity.DelegatePlayer;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.player.GameMode;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.user.BendingUser;
import me.moros.bending.api.util.FeaturePermissions;
import net.kyori.adventure.util.TriState;

final class BendingPlayer
extends BendingUser
implements DelegatePlayer {
    private final Cache<String, Boolean> permissionCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private Board board = Board.dummy();

    BendingPlayer(Game game, Player player) {
        super(game, player);
    }

    @Override
    public Player entity() {
        return (Player)super.entity();
    }

    @Override
    public boolean isSpectator() {
        return this.propertyValue(EntityProperties.GAMEMODE) == GameMode.SPECTATOR;
    }

    @Override
    public int currentSlot() {
        return this.inventory().selectedSlot() + 1;
    }

    @Override
    public void currentSlot(int slot) {
    }

    @Override
    public boolean hasPermission(String permission) {
        return (Boolean)this.permissionCache.get((Object)permission, this.entity()::hasPermission);
    }

    @Override
    public TriState setPermission(String permission, TriState state) {
        return TriState.NOT_SET;
    }

    @Override
    public Board board() {
        if (!this.canUseBoard()) {
            if (this.board.isEnabled()) {
                this.board.disableScoreboard();
                this.board = Board.dummy();
            }
        } else if (!this.board.isEnabled()) {
            this.board = Platform.instance().factory().buildBoard(this).orElseGet(Board::dummy);
        }
        return this.board;
    }

    private boolean canUseBoard() {
        if (this.store().has(Board.HIDDEN) || !this.game().worldManager().isEnabled(this.worldKey()) || !this.canBend()) {
            return false;
        }
        return this.hasElements() && this.hasPermission(FeaturePermissions.BOARD);
    }
}

