/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.temporal.Temporary;
import me.moros.tasker.TimerWheel;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TemporalManager<K, V extends Temporary> {
    private final TimerWheel wheel;
    private final Map<K, V> instances;
    private final boolean revertOnClear;
    private final AtomicBoolean clearing = new AtomicBoolean();
    private final int max;

    public TemporalManager(int wheelCapacity) {
        this(wheelCapacity, true);
    }

    public TemporalManager(int wheelCapacity, boolean revertOnClear) {
        this(TimerWheel.simple(wheelCapacity + 1), revertOnClear, wheelCapacity);
    }

    public TemporalManager(TimerWheel wheel) {
        this(wheel, true, 12000);
    }

    private TemporalManager(TimerWheel wheel, boolean revertOnClear, int max) {
        this.wheel = Objects.requireNonNull(wheel);
        this.instances = new ConcurrentHashMap();
        this.revertOnClear = revertOnClear;
        this.max = max;
    }

    public void tick() {
        this.wheel.advance();
    }

    public boolean isTemp(@Nullable K key) {
        return key != null && this.instances.containsKey(key);
    }

    public Optional<V> get(K key) {
        return Optional.ofNullable((Temporary)this.instances.get(key));
    }

    public void addEntry(K key, V value, int ticks) {
        if (this.isTemp(key) || ticks < 0) {
            return;
        }
        this.instances.put(key, value);
        this.wheel.schedule(value, ticks);
    }

    public boolean removeEntry(K key) {
        Temporary result = (Temporary)this.instances.remove(key);
        if (result != null) {
            result.cancel();
            return true;
        }
        return false;
    }

    public boolean clearing() {
        return this.clearing.get();
    }

    public void removeAll() {
        this.clearing.set(true);
        this.wheel.shutdown(this.revertOnClear);
        this.instances.clear();
        this.clearing.set(false);
    }

    public int fromMillis(long duration) {
        int time = Platform.instance().toTicks(duration, TimeUnit.MILLISECONDS);
        return time <= 0 ? this.max : Math.min(time, this.max);
    }

    public int size() {
        return this.instances.size();
    }

    protected Stream<V> stream() {
        return this.instances.values().stream();
    }
}

