/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.moros.bending.api.platform.world.World;
import me.moros.math.Vector3d;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class TempEntityBuilder<T, R, B extends TempEntityBuilder<T, R, B>> {
    protected final T data;
    protected final Set<UUID> viewers;
    protected Vector3d velocity = Vector3d.ZERO;
    protected boolean gravity = true;
    protected long duration = 30000L;

    TempEntityBuilder(T data) {
        this.data = data;
        this.viewers = new HashSet<UUID>();
    }

    public B velocity(Vector3d velocity) {
        this.velocity = Objects.requireNonNull(velocity).clampVelocity();
        return (B)this;
    }

    public B gravity(boolean gravity) {
        this.gravity = gravity;
        return (B)this;
    }

    public B duration(long duration) {
        this.duration = duration;
        return (B)this;
    }

    public B viewer(UUID viewer) {
        return this.viewers(List.of(viewer));
    }

    public B viewers(Collection<UUID> viewers) {
        this.viewers.clear();
        this.viewers.addAll(viewers);
        return (B)this;
    }

    public abstract @Nullable R build(World var1, Vector3d var2);
}

