/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.moros.bending.api.adapter.PacketUtil;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.display.BlockDisplayBuilder;
import me.moros.bending.api.platform.entity.display.Display;
import me.moros.bending.api.platform.entity.display.DisplayBuilder;
import me.moros.bending.api.platform.entity.display.ItemDisplayBuilder;
import me.moros.bending.api.platform.entity.display.TextDisplayBuilder;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.temporal.TempEntityBuilder;
import me.moros.bending.api.temporal.TemporalManager;
import me.moros.bending.api.temporal.Temporary;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TempDisplayEntity
extends Temporary {
    public static final TemporalManager<Integer, TempDisplayEntity> MANAGER = new TemporalManager<Integer, TempDisplayEntity>(600){

        @Override
        public void tick() {
            super.tick();
            TICKING_PHYSICS.values().forEach(DisplayMeta::tick);
        }
    };
    private static final Map<Integer, DisplayMeta> TICKING_PHYSICS = new HashMap<Integer, DisplayMeta>();
    private final int id;
    private boolean reverted = false;

    private TempDisplayEntity(int id, int ticks) {
        this.id = id;
        MANAGER.addEntry(this.id, this, ticks);
    }

    @Override
    public boolean revert() {
        if (this.reverted) {
            return false;
        }
        this.reverted = true;
        TICKING_PHYSICS.remove(this.id);
        Platform.instance().nativeAdapter().destroy(this.id);
        MANAGER.removeEntry(this.id);
        return true;
    }

    public static Builder<BlockDisplayBuilder> builder(BlockType data) {
        return TempDisplayEntity.builder(data.defaultState());
    }

    public static Builder<BlockDisplayBuilder> builder(BlockState data) {
        return TempDisplayEntity.builder(Display.block(data));
    }

    public static Builder<ItemDisplayBuilder> builder(Item data) {
        return TempDisplayEntity.builder(Display.item(data));
    }

    public static Builder<TextDisplayBuilder> builder(Component data) {
        return TempDisplayEntity.builder(Display.text(data));
    }

    public static <V, T extends DisplayBuilder<V, T>> Builder<T> builder(T builder) {
        return new Builder<T>(builder);
    }

    public static final class Builder<B extends DisplayBuilder<?, B>>
    extends TempEntityBuilder<B, TempDisplayEntity, Builder<B>> {
        private static final Vector3d BLOCK_OFFSET = Vector3d.of(0.5, 0.0, 0.5);
        private double minYOffset = -0.1;

        private Builder(B data) {
            super(data);
            this.gravity(false);
        }

        public Builder<B> edit(Consumer<B> consumer) {
            consumer.accept((DisplayBuilder)this.data);
            return this;
        }

        public Builder<B> minYOffset(double minYOffset) {
            this.minYOffset = minYOffset;
            return this;
        }

        public @Nullable TempDisplayEntity build(Block block) {
            return this.build(block.world(), (Vector3d)block.toVector3d().add(BLOCK_OFFSET));
        }

        @Override
        public @Nullable TempDisplayEntity build(World world, Vector3d center) {
            return this.displayEntity(world, center);
        }

        private @Nullable TempDisplayEntity displayEntity(World world, Vector3d center) {
            boolean hasPhysics;
            boolean bl = hasPhysics = this.gravity || this.velocity.lengthSq() > 0.0;
            if (hasPhysics) {
                ((DisplayBuilder)this.data).positionInterpolationDuration(1);
            }
            Display properties = ((DisplayBuilder)this.data).build();
            PacketUtil.ClientboundPacket packet = Platform.instance().nativeAdapter().createDisplayEntity(center, properties);
            int id = packet.id();
            if (id <= 0) {
                return null;
            }
            if (this.viewers.isEmpty()) {
                packet.broadcast(world, center);
            } else {
                packet.send(Set.copyOf(this.viewers));
            }
            TempDisplayEntity result = new TempDisplayEntity(id, MANAGER.fromMillis(this.duration));
            if (hasPhysics) {
                Vector3d pos = (Vector3d)center.add(properties.transformation().translation());
                TICKING_PHYSICS.put(id, new DisplayMeta(id, world, pos, this.velocity, this.minYOffset));
            }
            return result;
        }
    }

    private static final class DisplayMeta {
        private static final Vector3d GRAVITY = Vector3d.of(0.0, -0.04, 0.0);
        private static final double DRAG = 0.98;
        private final int id;
        private final World world;
        private final double minYOffset;
        private Vector3d position;
        private Vector3d velocity;

        private DisplayMeta(int id, World world, Vector3d position, Vector3d velocity, double minYOffset) {
            this.id = id;
            this.world = world;
            this.position = position;
            this.minYOffset = position.y() + minYOffset;
            this.velocity = velocity;
        }

        private void tick() {
            this.velocity = ((Vector3d)this.velocity.add(GRAVITY)).clampVelocity();
            this.move();
            this.velocity = (Vector3d)this.velocity.multiply(0.98);
        }

        private void move() {
            this.position = (Vector3d)this.position.add(this.velocity);
            if (this.position.y() < this.minYOffset) {
                this.position = (Vector3d)this.position.withY(this.minYOffset);
                return;
            }
            Platform.instance().nativeAdapter().updateDisplayPosition(this.id, this.position).broadcast(this.world, this.position);
        }
    }
}

