/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.registry;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import me.moros.bending.api.registry.Container;
import me.moros.bending.api.registry.Registry;
import me.moros.bending.api.registry.Tag;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;

public final class TagBuilder<V extends Keyed, R extends Tag<V>> {
    private final Function<Container<V>, R> function;
    private final Key key;
    private final Registry<?, V> registry;
    private final Set<V> container;

    public TagBuilder(Key key, Registry<?, V> registry, Function<Container<V>, R> function) {
        this.key = key;
        this.registry = registry;
        this.function = function;
        this.container = new HashSet<V>();
    }

    public TagBuilder<V, R> startsWith(String with) {
        return this.add((V value) -> TagBuilder.name(value).startsWith(with));
    }

    public TagBuilder<V, R> contains(String with) {
        return this.add((V value) -> TagBuilder.name(value).contains(with));
    }

    public TagBuilder<V, R> endsWith(String with) {
        return this.add((V value) -> TagBuilder.name(value).endsWith(with));
    }

    public TagBuilder<V, R> add(V type) {
        this.container.add(type);
        return this;
    }

    @SafeVarargs
    public final TagBuilder<V, R> add(V type, V ... other) {
        this.container.add(type);
        if (other != null) {
            this.container.addAll(List.of(other));
        }
        return this;
    }

    public TagBuilder<V, R> add(Iterable<V> values) {
        for (Keyed type : values) {
            this.container.add(type);
        }
        return this;
    }

    public TagBuilder<V, R> add(Predicate<V> predicate) {
        for (Keyed type : this.registry) {
            if (!predicate.test(type)) continue;
            this.container.add(type);
        }
        return this;
    }

    public TagBuilder<V, R> notStartsWith(String with) {
        return this.not((V value) -> TagBuilder.name(value).endsWith(with));
    }

    public TagBuilder<V, R> notContains(String with) {
        return this.not((V value) -> TagBuilder.name(value).contains(with));
    }

    public TagBuilder<V, R> notEndsWith(String with) {
        return this.not((V value) -> TagBuilder.name(value).endsWith(with));
    }

    public TagBuilder<V, R> not(V type) {
        this.container.remove(type);
        return this;
    }

    @SafeVarargs
    public final TagBuilder<V, R> not(V type, V ... other) {
        this.container.remove(type);
        if (other != null) {
            for (V val : other) {
                this.container.remove(val);
            }
        }
        return this;
    }

    public TagBuilder<V, R> not(Iterable<V> values) {
        for (Keyed type : values) {
            this.container.remove(type);
        }
        return this;
    }

    public TagBuilder<V, R> not(Predicate<V> predicate) {
        for (Keyed type : this.registry) {
            if (!predicate.test(type)) continue;
            this.container.remove(type);
        }
        return this;
    }

    public Container<V> buildContainer() {
        return Container.create(this.key, this.container);
    }

    public R build() {
        return (R)((Tag)this.function.apply(this.buildContainer()));
    }

    public R buildAndRegister() {
        R tag = this.build();
        this.registry.registerTag((Tag)tag);
        return tag;
    }

    private static String name(Keyed key) {
        return key.key().value();
    }
}

