/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.block.Lockable;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface BlockGetter {
    default public Block blockAt(Position position) {
        return this.blockAt(position.blockX(), position.blockY(), position.blockZ());
    }

    public Block blockAt(int var1, int var2, int var3);

    default public BlockType getBlockType(Position position) {
        return this.getBlockType(position.blockX(), position.blockY(), position.blockZ());
    }

    public BlockType getBlockType(int var1, int var2, int var3);

    default public BlockState getBlockState(Position position) {
        return this.getBlockState(position.blockX(), position.blockY(), position.blockZ());
    }

    public BlockState getBlockState(int var1, int var2, int var3);

    default public List<Block> nearbyBlocks(Vector3d pos, double radius) {
        return this.nearbyBlocks(pos, radius, block -> true, 0);
    }

    default public List<Block> nearbyBlocks(Vector3d pos, double radius, Predicate<Block> predicate) {
        return this.nearbyBlocks(pos, radius, predicate, 0);
    }

    default public List<Block> nearbyBlocks(Vector3d pos, double radius, Predicate<Block> predicate, int limit) {
        int r = FastMath.ceil(radius) + 1;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double x = pos.x() - (double)r; x <= pos.x() + (double)r; x += 1.0) {
            for (double y = pos.y() - (double)r; y <= pos.y() + (double)r; y += 1.0) {
                for (double z = pos.z() - (double)r; z <= pos.z() + (double)r; z += 1.0) {
                    Block block;
                    Vector3d loc = Vector3d.of(x, y, z);
                    if (pos.distanceSq(loc) > radius * radius || !predicate.test(block = this.blockAt(loc))) continue;
                    blocks.add(block);
                    if (limit <= 0 || blocks.size() < limit) continue;
                    return blocks;
                }
            }
        }
        return blocks;
    }

    default public List<Block> nearbyBlocks(AABB box) {
        return this.nearbyBlocks(box, block -> true, 0);
    }

    default public List<Block> nearbyBlocks(AABB box, Predicate<Block> predicate) {
        return this.nearbyBlocks(box, predicate, 0);
    }

    default public List<Block> nearbyBlocks(AABB box, Predicate<Block> predicate, int limit) {
        if (box.equals(AABB.dummy())) {
            return List.of();
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double x = box.min().x(); x <= box.max().x(); x += 1.0) {
            for (double y = box.min().y(); y <= box.max().y(); y += 1.0) {
                for (double z = box.min().z(); z <= box.max().z(); z += 1.0) {
                    Block block = this.blockAt(FastMath.floor(x), FastMath.floor(y), FastMath.floor(z));
                    if (!predicate.test(block)) continue;
                    blocks.add(block);
                    if (limit <= 0 || blocks.size() < limit) continue;
                    return blocks;
                }
            }
        }
        return blocks;
    }

    default public AABB blockBounds(Position position) {
        return this.blockBounds(position.blockX(), position.blockY(), position.blockZ());
    }

    public AABB blockBounds(int var1, int var2, int var3);

    public Optional<Block> findTop(Position var1, int var2, Predicate<Block> var3);

    public Optional<Block> findBottom(Position var1, int var2, Predicate<Block> var3);

    default public DataHolder blockMetadata(Position position) {
        return this.blockMetadata(position.blockX(), position.blockY(), position.blockZ());
    }

    public DataHolder blockMetadata(int var1, int var2, int var3);

    public boolean isBlockEntity(Position var1);

    public @Nullable Lockable containerLock(Position var1);
}

