/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.item;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemTag;
import me.moros.bending.api.registry.Container;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.functional.Suppliers;
import net.kyori.adventure.key.Key;

record TagImpl(Key key, Supplier<Container<Item>> supplier) implements ItemTag
{
    private static final Container<Item> EMPTY = Container.create(KeyUtil.simple("empty"), Set.of());

    static ItemTag get(String key) {
        return TagImpl.reference(KeyUtil.vanilla(key));
    }

    static ItemTag reference(Key key) {
        return new TagImpl(key, Suppliers.lazy(() -> Item.registry().getTag(key)));
    }

    static ItemTag fromContainer(Container<Item> container) {
        return new TagImpl(container.key(), Suppliers.cached(container));
    }

    Container<Item> container() {
        Container<Item> container = this.supplier().get();
        return container == null ? EMPTY : container;
    }

    @Override
    public boolean containsValue(Item type) {
        return this.container().containsValue(type);
    }

    @Override
    public int size() {
        return this.container().size();
    }

    @Override
    public Stream<Item> stream() {
        return this.container().stream();
    }

    @Override
    public Iterator<Item> iterator() {
        return this.container().iterator();
    }
}

