/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity.display;

import me.moros.math.Position;
import me.moros.math.Quaternion;
import me.moros.math.Vector3d;

public record Transformation(Position translation, Quaternion left, Position scale, Quaternion right) {
    public Transformation(Position translation, Position scale) {
        this(translation, QuaternionRotation.ZERO, scale, QuaternionRotation.ZERO);
    }

    public Transformation withTranslation(Position translation) {
        return new Transformation(translation, this.left, this.scale, this.right);
    }

    public Transformation withScale(Position scale) {
        return new Transformation(this.translation, this.left, scale, this.right);
    }

    public Transformation withLeftRotation(Quaternion left) {
        return new Transformation(this.translation, left, this.scale, this.right);
    }

    public Transformation withRightRotation(Quaternion right) {
        return new Transformation(this.translation, this.left, this.scale, right);
    }

    public static Transformation scaled(double scale) {
        return new Transformation(Vector3d.ZERO, (Position)Vector3d.ONE.multiply(scale));
    }

    private record QuaternionRotation(double q0, double q1, double q2, double q3) implements Quaternion
    {
        private static final QuaternionRotation ZERO = new QuaternionRotation(1.0, 0.0, 0.0, 0.0);
    }
}

